/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.restful.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.hasor.core.AppContext;
import net.hasor.web.restful.HttpMethod;
import net.hasor.web.restful.Path;
import net.hasor.web.restful.Produces;
import net.hasor.web.restful.support.RestfulInvoke;
import org.more.UndefinedException;
import org.more.classcode.FormatException;
import org.more.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestfulInvokeDefine {
    private String[] httpMethod;
    private String restfulMapping;
    private String restfulMappingMatches;
    private String produces;
    private Method targetMethod;
    private Class<?> targetClass;
    private AppContext appContext;

    protected RestfulInvokeDefine(AppContext appContext, Method targetMethod) {
        Path pathAnno = targetMethod.getAnnotation(Path.class);
        if (pathAnno == null) {
            throw new UndefinedException("is not a valid Restful Service.");
        }
        String servicePath = pathAnno.value();
        if (StringUtils.isBlank((String)servicePath)) {
            throw new NullPointerException("Service path is empty.");
        }
        if (!servicePath.matches("/.+")) {
            throw new FormatException("Service path format error");
        }
        Annotation[] annos = targetMethod.getAnnotations();
        ArrayList<String> allHttpMethod = new ArrayList<String>();
        if (annos != null) {
            for (Annotation anno : annos) {
                String bindMethod;
                HttpMethod httpMethodAnno = anno.annotationType().getAnnotation(HttpMethod.class);
                if (httpMethodAnno == null || StringUtils.isBlank((String)(bindMethod = httpMethodAnno.value()))) continue;
                allHttpMethod.add(bindMethod);
            }
        }
        if (allHttpMethod.isEmpty()) {
            allHttpMethod.add("ANY");
        }
        this.httpMethod = allHttpMethod.toArray(new String[allHttpMethod.size()]);
        Produces produces = targetMethod.getAnnotation(Produces.class);
        if (produces != null) {
            this.produces = produces.value();
        }
        this.restfulMapping = servicePath;
        this.targetMethod = targetMethod;
        this.targetClass = targetMethod.getDeclaringClass();
        this.appContext = appContext;
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getRestfulMapping() {
        return this.restfulMapping;
    }

    public String getProduces() {
        return this.produces;
    }

    public String getRestfulMappingMatches() {
        if (this.restfulMappingMatches == null) {
            this.restfulMappingMatches = this.restfulMapping.replaceAll("\\{\\w{1,}\\}", "([^/]{1,})");
        }
        return this.restfulMappingMatches;
    }

    public boolean matchingMethod(String httpMethod) {
        for (String m : this.httpMethod) {
            if (StringUtils.equalsIgnoreCase((String)httpMethod, (String)m)) {
                return true;
            }
            if (!StringUtils.equalsIgnoreCase((String)m, (String)"ANY")) continue;
            return true;
        }
        return false;
    }

    public RestfulInvoke createIvnoke() {
        return new RestfulInvoke(this);
    }
}

