/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.restful.support;

import com.google.inject.Inject;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.web.restful.Path;
import net.hasor.web.restful.RestfulService;
import net.hasor.web.restful.support.RestfulInvoke;
import net.hasor.web.restful.support.RestfulInvokeDefine;
import org.more.util.BeanUtils;
import org.more.util.exception.ExceptionUtils;

@Singleton
class RestfulController
implements Filter {
    @Inject
    private AppContext appContext = null;
    private RestfulInvokeDefine[] invokeArray = null;
    public static final String REQUEST_DISPATCHER_REQUEST = "javax.servlet.forward.servlet_path";

    RestfulController() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Set controllerSet = this.appContext.getClassSet(RestfulService.class);
        if (controllerSet == null) {
            return;
        }
        ArrayList<RestfulInvokeDefine> restfulList = new ArrayList<RestfulInvokeDefine>();
        for (Class controllerType : controllerSet) {
            List actionMethods = BeanUtils.getMethods((Class)controllerType);
            for (Method targetMethod : actionMethods) {
                if (targetMethod.getAnnotation(Path.class) == null) continue;
                restfulList.add(new RestfulInvokeDefine(this.appContext, targetMethod));
            }
        }
        Collections.sort(restfulList, new Comparator<RestfulInvokeDefine>(){

            @Override
            public int compare(RestfulInvokeDefine o1, RestfulInvokeDefine o2) {
                return o1.getRestfulMapping().compareToIgnoreCase(o2.getRestfulMapping()) * -1;
            }
        });
        this.invokeArray = restfulList.toArray(new RestfulInvokeDefine[restfulList.size()]);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String actionPath = request.getRequestURI().substring(request.getContextPath().length());
        RestfulInvokeDefine define = this.getRestfulInvoke(request.getMethod(), actionPath);
        if (define == null) {
            chain.doFilter((ServletRequest)request, resp);
            return;
        }
        this.doInvoke(define, (ServletRequest)request, resp);
    }

    private RestfulInvokeDefine getRestfulInvoke(String httpMethod, String requestPath) {
        for (RestfulInvokeDefine restAction : this.invokeArray) {
            if (!requestPath.matches(restAction.getRestfulMappingMatches()) || !restAction.matchingMethod(httpMethod)) continue;
            return restAction;
        }
        return null;
    }

    private void doInvoke(RestfulInvokeDefine define, ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        try {
            RestfulInvoke invoke = define.createIvnoke();
            invoke.initHttp((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            invoke.invoke();
        }
        catch (Throwable e) {
            Throwable target = ExceptionUtils.getCause((Throwable)e);
            Throwable throwable = target = target == null ? e : target;
            if (target instanceof ServletException) {
                throw (ServletException)target;
            }
            if (target instanceof IOException) {
                throw (ServletException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new ServletException(target);
        }
    }

    public RequestDispatcher getRequestDispatcher(final String newRequestUri, HttpServletRequest request) {
        final RestfulInvokeDefine define = this.getRestfulInvoke(request.getMethod(), newRequestUri);
        if (define == null) {
            return null;
        }
        return new RequestDispatcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                servletRequest.setAttribute(RestfulController.REQUEST_DISPATCHER_REQUEST, (Object)Boolean.TRUE);
                try {
                    RestfulController.this.doInvoke(define, servletRequest, servletResponse);
                }
                finally {
                    servletRequest.removeAttribute(RestfulController.REQUEST_DISPATCHER_REQUEST);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                if (servletResponse.isCommitted()) {
                    throw new ServletException("Response has been committed--you can only call forward before committing the response (hint: don't flush buffers)");
                }
                servletResponse.resetBuffer();
                Object requestToProcess = servletRequest instanceof HttpServletRequest ? new RequestDispatcherRequestWrapper(servletRequest, newRequestUri) : servletRequest;
                servletRequest.setAttribute(RestfulController.REQUEST_DISPATCHER_REQUEST, (Object)Boolean.TRUE);
                try {
                    RestfulController.this.doInvoke(define, requestToProcess, servletResponse);
                }
                finally {
                    servletRequest.removeAttribute(RestfulController.REQUEST_DISPATCHER_REQUEST);
                }
            }
        };
    }

    private static class RequestDispatcherRequestWrapper
    extends HttpServletRequestWrapper {
        private final String newRequestUri;

        public RequestDispatcherRequestWrapper(ServletRequest servletRequest, String newRequestUri) {
            super((HttpServletRequest)servletRequest);
            this.newRequestUri = newRequestUri;
        }

        public String getRequestURI() {
            return this.newRequestUri;
        }
    }
}

