/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.resource.support;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.hasor.Hasor;
import net.hasor.core.AppContext;
import net.hasor.core.Environment;
import net.hasor.core.Settings;
import net.hasor.core.context.AnnoModule;
import net.hasor.core.gift.GiftSupportModule;
import net.hasor.web.resource.ResourceLoaderCreator;
import net.hasor.web.resource.ResourceLoaderDefine;
import net.hasor.web.resource.support.ResourceHttpServlet;
import net.hasor.web.resource.support.ResourceLoaderProvider;
import net.hasor.web.resource.support.ResourceSettings;
import net.hasor.web.servlet.WebApiBinder;
import net.hasor.web.servlet.WebModule;
import org.more.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AnnoModule
public class WebResourceModule
extends WebModule {
    @Override
    public void init(WebApiBinder apiBinder) {
        String[] types;
        apiBinder.dependency().weak(GiftSupportModule.class);
        Settings settings = apiBinder.getEnvironment().getSettings();
        ResourceSettings resSettings = new ResourceSettings(settings);
        apiBinder.bindingType(ResourceSettings.class).toInstance((Object)resSettings);
        if (!resSettings.isEnable()) {
            return;
        }
        WebResourceModule.initServlet(apiBinder);
        for (String t : types = resSettings.getContentTypes()) {
            Hasor.info((String)"*.%s use ResourceHttpServlet.", (Object[])new Object[]{t});
            apiBinder.serve("*." + t, new String[0]).with(ResourceHttpServlet.class);
        }
    }

    @Override
    public void start(AppContext appContext) {
    }

    @Override
    public void stop(AppContext appContext) {
    }

    private static Map<String, Class<ResourceLoaderCreator>> loadResourceLoader(WebApiBinder apiBinder) {
        HashMap<String, Class<ResourceLoaderCreator>> creatorMap = new HashMap<String, Class<ResourceLoaderCreator>>();
        Set resourceLoaderCreatorSet = apiBinder.getEnvironment().getClassSet(ResourceLoaderDefine.class);
        if (resourceLoaderCreatorSet == null) {
            return creatorMap;
        }
        ArrayList<Class> resourceLoaderCreatorList = new ArrayList<Class>();
        for (Class cls : resourceLoaderCreatorSet) {
            if (!ResourceLoaderCreator.class.isAssignableFrom(cls)) {
                Hasor.warning((String)"loadResourceLoader : not implemented ResourceLoaderCreator. class=%s", (Object[])new Object[]{cls});
                continue;
            }
            resourceLoaderCreatorList.add(cls);
        }
        for (Class creatorType : resourceLoaderCreatorList) {
            ResourceLoaderDefine creatorAnno = creatorType.getAnnotation(ResourceLoaderDefine.class);
            String defineName = creatorAnno.configElement();
            if (StringUtils.isBlank((String)defineName)) {
                Hasor.warning((String)"loadResourceLoader %s miss name.", (Object[])new Object[]{creatorType});
                continue;
            }
            creatorMap.put(defineName.toUpperCase(), creatorType);
            Hasor.info((String)"loadResourceLoader %s at %s.", (Object[])new Object[]{defineName, creatorType});
        }
        return creatorMap;
    }

    private static void initServlet(WebApiBinder apiBinder) {
        Environment env = apiBinder.getEnvironment();
        Map<String, Class<ResourceLoaderCreator>> creatorMap = WebResourceModule.loadResourceLoader(apiBinder);
        Settings settings = env.getSettings();
        ResourceSettings resSettings = new ResourceSettings(settings);
        for (ResourceSettings.LoaderConfig item : resSettings.getLoaders()) {
            String loaderType = item.loaderType;
            String configVal = item.config.getText();
            Class<ResourceLoaderCreator> creatorType = creatorMap.get(loaderType.toUpperCase());
            if (creatorType == null) {
                Hasor.warning((String)"missing %s ResourceLoaderCreator config is %s.", (Object[])new Object[]{loaderType, configVal});
                continue;
            }
            ResourceLoaderProvider rlcd = new ResourceLoaderProvider(loaderType, item.config, creatorType);
            apiBinder.bindingType(ResourceLoaderProvider.class).toInstance((Object)rlcd);
            Hasor.info((String)"add %s ResourceLoaderCreator config is %s.", (Object[])new Object[]{loaderType, configVal});
        }
        String cacheSubPath = "%HASOR_PLUGIN_PATH%/net.hasor.web.resource/";
        File cacheDir = new File(env.evalString(cacheSubPath));
        if (!WebResourceModule.chekcCacheDir(cacheDir)) {
            int i = 0;
            while (!WebResourceModule.chekcCacheDir(cacheDir = new File(env.evalString(cacheSubPath + "_" + String.valueOf(i))))) {
            }
        }
        ResourceHttpServlet.initCacheDir(cacheDir);
    }

    private static boolean chekcCacheDir(File cacheDir) {
        cacheDir.mkdirs();
        return cacheDir.isDirectory() || !cacheDir.exists();
    }
}

