/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.resource.support;

import java.util.ArrayList;
import java.util.HashSet;
import net.hasor.core.Settings;
import net.hasor.core.XmlNode;
import org.more.util.StringUtils;

class ResourceSettings {
    private boolean enable = false;
    private String[] contentTypes = null;
    private LoaderConfig[] loaders = null;

    public ResourceSettings(Settings settings) {
        this.enable = settings.getBoolean("hasor-web.resourceLoader.enable");
        String typesRoot = settings.getString("hasor-web.resourceLoader.contentTypes");
        typesRoot = typesRoot == null ? "" : typesRoot;
        HashSet<String> typesArray = new HashSet<String>();
        for (String type : typesRoot.split(",")) {
            if (StringUtils.isBlank((String)type)) continue;
            typesArray.add(type.trim());
        }
        this.contentTypes = typesArray.toArray(new String[typesArray.size()]);
        XmlNode[] loaderRootArray = settings.getXmlPropertyArray("hasor-web.resourceLoader");
        ArrayList<LoaderConfig> loaderArray = new ArrayList<LoaderConfig>();
        for (XmlNode loaderRoot : loaderRootArray) {
            for (XmlNode c : loaderRoot.getChildren()) {
                LoaderConfig lc = new LoaderConfig();
                lc.loaderType = c.getName();
                lc.config = c;
                loaderArray.add(lc);
            }
        }
        this.loaders = loaderArray.toArray(new LoaderConfig[loaderArray.size()]);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String[] getContentTypes() {
        return this.contentTypes;
    }

    public LoaderConfig[] getLoaders() {
        return (LoaderConfig[])this.loaders.clone();
    }

    public static class LoaderConfig {
        public String loaderType = null;
        public XmlNode config = null;
    }
}

