/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.resource.support;

import com.google.inject.Provider;
import java.io.IOException;
import net.hasor.core.AppContext;
import net.hasor.core.XmlNode;
import net.hasor.web.resource.ResourceLoader;
import net.hasor.web.resource.ResourceLoaderCreator;
import org.more.UnhandledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceLoaderProvider
implements Provider<ResourceLoader> {
    private String loaderType;
    private XmlNode xmlSettings;
    private Class<ResourceLoaderCreator> loaderCreator;
    private AppContext appContext = null;
    private ResourceLoader loaderObject = null;

    public ResourceLoaderProvider(String loaderType, XmlNode xmlSettings, Class<ResourceLoaderCreator> loaderCreator) {
        this.loaderType = loaderType;
        this.xmlSettings = xmlSettings;
        this.loaderCreator = loaderCreator;
    }

    public String getLoaderType() {
        return this.loaderType;
    }

    public void setAppContext(AppContext appContext) {
        this.appContext = appContext;
    }

    public ResourceLoader get() {
        if (this.loaderObject != null) {
            return this.loaderObject;
        }
        try {
            ResourceLoaderCreator creator = (ResourceLoaderCreator)this.appContext.getInstance(this.loaderCreator);
            this.loaderObject = creator.newInstance(this.appContext, this.xmlSettings);
            return this.loaderObject;
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
    }
}

