/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.resource.loader;

import java.io.File;
import java.io.IOException;
import net.hasor.Hasor;
import net.hasor.core.AppContext;
import net.hasor.core.XmlNode;
import net.hasor.web.resource.ResourceLoader;
import net.hasor.web.resource.ResourceLoaderCreator;
import net.hasor.web.resource.ResourceLoaderDefine;
import net.hasor.web.resource.loader.ZipResourceLoader;
import org.more.util.StringUtils;

@ResourceLoaderDefine(configElement="ZipLoader")
public class ZipResourceLoaderCreator
implements ResourceLoaderCreator {
    public ResourceLoader newInstance(AppContext appContext, XmlNode xmlConfig) throws IOException {
        String body = xmlConfig.getText();
        body = StringUtils.isBlank((String)body) ? "" : body;
        body = appContext.getEnvironment().evalString(body);
        File fileBody = new File(body);
        if (!fileBody.exists() || fileBody.isDirectory()) {
            return null;
        }
        Hasor.info((String)"loadZip %s -> %s", (Object[])new Object[]{xmlConfig.getText(), fileBody});
        ZipResourceLoader dirTemplateLoader = new ZipResourceLoader(fileBody.getAbsolutePath());
        return dirTemplateLoader;
    }
}

