/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.resource.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.hasor.web.resource.ResourceLoader;

class ZipResourceLoader
implements ResourceLoader {
    private File zipFile = null;

    public ZipResourceLoader(String zipFile) throws IOException {
        this.zipFile = new File(zipFile);
    }

    public String getZipFile() {
        return this.zipFile.getAbsolutePath();
    }

    public InputStream getResourceAsStream(String name) throws IOException {
        ZipFile zipFileObj;
        ZipEntry entry;
        if (this.zipFile.isDirectory() || !this.zipFile.exists()) {
            return null;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        if ((entry = (zipFileObj = new ZipFile(this.zipFile)).getEntry(name)) == null) {
            return null;
        }
        return zipFileObj.getInputStream(entry);
    }
}

