/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.gift.servlet3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import net.hasor.Hasor;
import net.hasor.core.ApiBinder;
import net.hasor.core.gift.Gift;
import net.hasor.core.gift.GiftFace;
import net.hasor.gift.servlet3.WebFilter;
import net.hasor.gift.servlet3.WebInitParam;
import net.hasor.gift.servlet3.WebServlet;
import net.hasor.web.servlet.WebApiBinder;
import org.more.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Gift
public class Servlet3Gift
implements GiftFace {
    public void loadGift(ApiBinder apiBinder) {
        if (!(apiBinder instanceof WebApiBinder)) {
            return;
        }
        WebApiBinder webBinder = (WebApiBinder)apiBinder;
        this.loadFilter(webBinder);
        this.loadServlet(webBinder);
    }

    protected void loadFilter(WebApiBinder apiBinder) {
        Set webFilterSet = apiBinder.getClassSet(WebFilter.class);
        if (webFilterSet == null) {
            return;
        }
        ArrayList<Class> webFilterList = new ArrayList<Class>();
        for (Class cls : webFilterSet) {
            if (!Filter.class.isAssignableFrom(cls)) {
                Hasor.warning((String)"not implemented Filter :%s", (Object[])new Object[]{cls});
                continue;
            }
            webFilterList.add(cls);
        }
        for (Class filterType : webFilterList) {
            WebFilter filterAnno = filterType.getAnnotation(WebFilter.class);
            Map<String, String> initMap = this.toMap(filterAnno.initParams());
            apiBinder.filter(null, filterAnno.value()).through(filterAnno.sort(), filterType, initMap);
            String filterName = StringUtils.isBlank((String)filterAnno.filterName()) ? filterType.getSimpleName() : filterAnno.filterName();
            Hasor.info((String)"loadFilter %s[%s] bind %s on %s.", (Object[])new Object[]{filterName, Servlet3Gift.getIndexStr(filterAnno.sort()), filterType, filterAnno.value()});
        }
    }

    protected void loadServlet(WebApiBinder apiBinder) {
        Set webServletSet = apiBinder.getClassSet(WebServlet.class);
        if (webServletSet == null) {
            return;
        }
        ArrayList<Class> webServletList = new ArrayList<Class>();
        for (Class cls : webServletSet) {
            if (!HttpServlet.class.isAssignableFrom(cls)) {
                Hasor.warning((String)"not implemented HttpServlet :%s", (Object[])new Object[]{cls});
                continue;
            }
            webServletList.add(cls);
        }
        for (Class servletType : webServletList) {
            WebServlet servletAnno = servletType.getAnnotation(WebServlet.class);
            Map<String, String> initMap = this.toMap(servletAnno.initParams());
            String servletName = StringUtils.isBlank((String)servletAnno.servletName()) ? servletType.getSimpleName() : servletAnno.servletName();
            int sortInt = servletAnno.loadOnStartup();
            apiBinder.serve(null, servletAnno.value()).with(sortInt, servletType, initMap);
            Hasor.info((String)"loadServlet %s[%s] bind %s on %s.", (Object[])new Object[]{servletName, Servlet3Gift.getIndexStr(sortInt), servletType, servletAnno.value()});
        }
    }

    protected Map<String, String> toMap(WebInitParam[] initParams) {
        HashMap<String, String> initMap = new HashMap<String, String>();
        if (initParams != null) {
            for (WebInitParam param : initParams) {
                if (StringUtils.isBlank((String)param.name())) continue;
                initMap.put(param.name(), param.value());
            }
        }
        return initMap;
    }

    private static String getIndexStr(int index) {
        int allRange = 1000;
        int minStartIndex = Integer.MIN_VALUE;
        int minStopIndex = Integer.MIN_VALUE + allRange;
        for (int i = minStartIndex; i < minStopIndex; ++i) {
            if (index != i) continue;
            return "Min" + (index == Integer.MIN_VALUE ? "" : "+" + String.valueOf(i + Math.abs(Integer.MIN_VALUE)));
        }
        int maxStartIndex = Integer.MAX_VALUE;
        int maxStopIndex = Integer.MAX_VALUE - allRange;
        for (int i = maxStartIndex; i > maxStopIndex; --i) {
            if (index != i) continue;
            return "Max" + (index == Integer.MAX_VALUE ? "" : "-" + Math.abs(Integer.MAX_VALUE - i));
        }
        return String.valueOf(index);
    }
}

