/*
 * Copyright 2008-2009 the original (zyc@hasor.net).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.hasor.web.servlet;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContext;
import net.hasor.core.Module;
/**
 * 
 * @version : 2013-7-16
 * @author  (zyc@hasor.net)
 */
public abstract class WebModule implements Module {
    public final void init(ApiBinder apiBinder) {
        if (apiBinder instanceof WebApiBinder)
            this.init((WebApiBinder) apiBinder);
        else
            throw new UnsupportedOperationException("Hasor context does not support the web module.");
    }
    /**ʼ̡*/
    public abstract void init(WebApiBinder apiBinder);
    /**ź*/
    public abstract void start(AppContext appContext);
    /**ֹͣź*/
    public abstract void stop(AppContext appContext);
}