/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.mvc.support;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hasor.core.AppContext;
import net.hasor.core.AppContextAware;
import net.hasor.mvc.support.FindMapping;
import net.hasor.mvc.support.MappingDefine;

class RootController
implements AppContextAware {
    private AppContext appContext = null;
    private MappingDefine[] invokeArray = new MappingDefine[0];
    private AtomicBoolean inited = new AtomicBoolean(false);

    RootController() {
    }

    public void setAppContext(AppContext appContext) {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.appContext = appContext;
        List mappingList = this.appContext.findBindingBean(MappingDefine.class);
        Collections.sort(mappingList, new Comparator<MappingDefine>(){

            @Override
            public int compare(MappingDefine o1, MappingDefine o2) {
                return o1.getMappingTo().compareToIgnoreCase(o2.getMappingTo()) * -1;
            }
        });
        for (MappingDefine define : mappingList) {
            this.initDefine(define);
        }
        MappingDefine[] defineArrays = mappingList.toArray(new MappingDefine[mappingList.size()]);
        if (defineArrays != null) {
            this.invokeArray = defineArrays;
        }
    }

    protected AppContext getAppContext() {
        return this.appContext;
    }

    protected void initDefine(MappingDefine define) {
        if (define != null) {
            define.init(this.appContext);
        }
    }

    public final MappingDefine findMapping(String controllerPath) {
        for (MappingDefine invoke : this.invokeArray) {
            if (!this.matchingMapping(controllerPath, invoke)) continue;
            return invoke;
        }
        return null;
    }

    public MappingDefine findMapping(FindMapping findMapping) {
        for (MappingDefine invoke : this.invokeArray) {
            if (!findMapping.matching(invoke)) continue;
            return invoke;
        }
        return null;
    }

    protected boolean matchingMapping(String controllerPath, MappingDefine atInvoke) {
        if (atInvoke == null) {
            return false;
        }
        return atInvoke.matchingMapping(controllerPath);
    }
}

