/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.mvc.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.core.Hasor;
import net.hasor.core.Provider;
import net.hasor.mvc.Call;
import net.hasor.mvc.CallStrategy;
import net.hasor.mvc.MappingInfo;
import net.hasor.mvc.ModelController;
import net.hasor.mvc.api.HttpMethod;
import net.hasor.mvc.api.MappingTo;
import net.hasor.mvc.support.HttpInfo;
import org.more.UndefinedException;
import org.more.builder.ReflectionToStringBuilder;
import org.more.builder.ToStringStyle;
import org.more.util.StringUtils;

class MappingDefine
implements MappingInfo {
    private String bindID;
    private Provider<ModelController> targetProvider;
    private Method targetMethod;
    private Class<?>[] targetParamTypes;
    private Annotation[][] targetParamAnno;
    private Annotation[] targetMethodAnno;
    private String mappingTo;
    private String mappingToMatches;
    private String[] httpMethod;
    private CallStrategy callStrategy;
    private AtomicBoolean inited = new AtomicBoolean(false);

    protected MappingDefine(String bindID, Method targetMethod) {
        MappingTo pathAnno = targetMethod.getAnnotation(MappingTo.class);
        if (pathAnno == null) {
            throw new UndefinedException("is not a valid Mapping Service.");
        }
        String servicePath = pathAnno.value();
        if (StringUtils.isBlank((String)servicePath)) {
            throw new NullPointerException("Service path is empty.");
        }
        if (!servicePath.matches("/.+")) {
            throw new IllegalStateException("Service path format error");
        }
        this.bindID = bindID;
        this.targetMethod = targetMethod;
        this.targetParamTypes = targetMethod.getParameterTypes();
        this.targetParamAnno = targetMethod.getParameterAnnotations();
        this.targetMethodAnno = targetMethod.getAnnotations();
        this.mappingTo = servicePath;
        this.mappingToMatches = servicePath.replaceAll("\\{\\w{1,}\\}", "([^/]{1,})");
        Annotation[] annos = targetMethod.getAnnotations();
        ArrayList<String> allHttpMethod = new ArrayList<String>();
        if (annos != null) {
            for (Annotation anno : annos) {
                String bindMethod;
                HttpMethod httpMethodAnno = anno.annotationType().getAnnotation(HttpMethod.class);
                if (httpMethodAnno == null || StringUtils.isBlank((String)(bindMethod = httpMethodAnno.value()))) continue;
                allHttpMethod.add(bindMethod);
            }
        }
        if (allHttpMethod.isEmpty()) {
            allHttpMethod.add("ANY");
        }
        this.httpMethod = allHttpMethod.toArray(new String[allHttpMethod.size()]);
    }

    @Override
    public String getMappingTo() {
        return this.mappingTo;
    }

    @Override
    public String getMappingToMatches() {
        return this.mappingToMatches;
    }

    public boolean matchingMapping(String requestPath) {
        Hasor.assertIsNotNull((Object)requestPath, (String)"requestPath is null.");
        return requestPath.matches(this.mappingToMatches);
    }

    public String[] getHttpMethod() {
        return this.httpMethod;
    }

    public boolean matchingMethod(String httpMethod) {
        for (String m : this.httpMethod) {
            if (StringUtils.equalsIgnoreCase((String)httpMethod, (String)m)) {
                return true;
            }
            if (!StringUtils.equalsIgnoreCase((String)m, (String)"ANY")) continue;
            return true;
        }
        return false;
    }

    protected void init(AppContext appContext) {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        Hasor.assertIsNotNull((Object)appContext, (String)"appContext is null.");
        BindInfo controllerInfo = appContext.getBindInfo(this.bindID);
        this.targetProvider = appContext.getProvider(controllerInfo);
    }

    public final Object invoke(final HttpInfo httpInfo, CallStrategy callStrategy, Map<String, ?> params) throws Throwable {
        Hasor.assertIsNotNull((Object)callStrategy);
        final ModelController mc = (ModelController)this.targetProvider.get();
        final HashMap atParams = params == null ? new HashMap() : params;
        Call call = new Call(){

            @Override
            public Set<String> getParamKeys() {
                return atParams.keySet();
            }

            @Override
            public Object getParam(String key) {
                return atParams.get(key);
            }

            @Override
            public Method getMethod() {
                return MappingDefine.this.targetMethod;
            }

            @Override
            public Class<?>[] getParameterTypes() {
                return MappingDefine.this.targetParamTypes;
            }

            @Override
            public Annotation[][] getMethodParamAnnos() {
                return MappingDefine.this.targetParamAnno;
            }

            @Override
            public Annotation[] getAnnotations() {
                return MappingDefine.this.targetMethodAnno;
            }

            @Override
            public ModelController getTarget() {
                return mc;
            }

            @Override
            public MappingInfo getMappingInfo() {
                return MappingDefine.this;
            }

            @Override
            public Object call(Object ... objects) throws Throwable {
                try {
                    return MappingDefine.this.targetMethod.invoke((Object)mc, objects);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }

            @Override
            public HttpServletRequest getHttpRequest() {
                return httpInfo.getHttpRequest();
            }

            @Override
            public HttpServletResponse getHttpResponse() {
                return httpInfo.getHttpResponse();
            }
        };
        return callStrategy.exeCall(call);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

