/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.mvc.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.UUID;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContextAware;
import net.hasor.core.BindInfo;
import net.hasor.mvc.ModelController;
import net.hasor.mvc.ResultProcess;
import net.hasor.mvc.api.MappingTo;
import net.hasor.mvc.result.support.ResultDefine;
import net.hasor.mvc.support.ControllerModule;
import net.hasor.mvc.support.MappingDefine;
import org.more.logger.LoggerHelper;

public abstract class LoadHellper {
    LoadHellper() {
    }

    protected abstract ControllerModule module();

    protected abstract ApiBinder apiBinder();

    public void loadResultProcess(Class<? extends Annotation> annoType, Class<? extends ResultProcess> processType) {
        ApiBinder apiBinder = this.apiBinder();
        LoggerHelper.logInfo((String)"loadResultDefine annoType is %s toInstance %s", (Object[])new Object[]{annoType, processType});
        BindInfo processBindInfo = apiBinder.bindType(ResultProcess.class).uniqueName().to(processType).asEagerSingleton().toInfo();
        ResultDefine define = (ResultDefine)apiBinder.autoAware((AppContextAware)new ResultDefine(annoType, (BindInfo<ResultProcess>)processBindInfo));
        apiBinder.bindType(ResultDefine.class).uniqueName().toInstance((Object)define);
    }

    public void loadType(Class<? extends ModelController> clazz) {
        Method[] methodArrays;
        int modifier = clazz.getModifiers();
        if (LoadHellper.checkIn(modifier, 512) || LoadHellper.checkIn(modifier, 1024)) {
            return;
        }
        String newID = UUID.randomUUID().toString();
        boolean hasMapping = false;
        ApiBinder apiBinder = this.apiBinder();
        for (Method atMethod : methodArrays = clazz.getMethods()) {
            if (!atMethod.isAnnotationPresent(MappingTo.class)) continue;
            hasMapping = true;
            MappingTo mto = atMethod.getAnnotation(MappingTo.class);
            LoggerHelper.logInfo((String)"method \u2018%s\u2019 mappingTo: \u2018%s\u2019, form Type :%s.", (Object[])new Object[]{atMethod.getName(), mto.value(), clazz.getName()});
            MappingDefine define = this.module().createMappingDefine(newID, atMethod);
            apiBinder.bindType(MappingDefine.class).uniqueName().toInstance((Object)define);
        }
        if (hasMapping) {
            apiBinder.bindType(clazz).idWith(newID);
        }
    }

    private static boolean checkIn(int data, int check) {
        int or = data | check;
        return or == data;
    }
}

