/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.mvc.support;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.mvc.result.support.DefineList;
import net.hasor.mvc.result.support.ResultCallStrategy;
import net.hasor.mvc.strat.DefaultCallStrategy;
import net.hasor.mvc.support.FindMapping;
import net.hasor.mvc.support.HttpInfo;
import net.hasor.mvc.support.MappingDefine;
import net.hasor.mvc.support.RootController;
import net.hasor.web.startup.RuntimeListener;

class ControllerFilter
implements Filter {
    private RootController rootController = null;
    private DefineList defineList = null;
    public static final String REQUEST_DISPATCHER_REQUEST = "javax.servlet.forward.servlet_path";

    ControllerFilter() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        AppContext appContext = RuntimeListener.getLocalAppContext();
        this.rootController = (RootController)appContext.getInstance(RootController.class);
        if (this.rootController == null) {
            throw new NullPointerException("RootController is null.");
        }
        this.defineList = (DefineList)appContext.getInstance(DefineList.class);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String actionPath = request.getRequestURI().substring(request.getContextPath().length());
        MappingDefine define = this.rootController.findMapping(new FindMapping(actionPath, request.getMethod()));
        if (define == null) {
            chain.doFilter((ServletRequest)request, resp);
            return;
        }
        this.doInvoke(define, (ServletRequest)request, resp);
    }

    private void doInvoke(MappingDefine define, ServletRequest servletRequest, final ServletResponse servletResponse) throws ServletException, IOException {
        try {
            Object httpReq = (HttpServletRequest)servletRequest;
            Object infoHttpReq = httpReq = new HttpServletRequestWrapper((HttpServletRequest)httpReq){

                public RequestDispatcher getRequestDispatcher(String path) {
                    RequestDispatcher dispatcher = ControllerFilter.this.getReqDispatcher(path, (HttpServletRequest)this);
                    return null != dispatcher ? dispatcher : super.getRequestDispatcher(path);
                }
            };
            define.invoke(new HttpInfo((HttpServletRequest)infoHttpReq){
                final /* synthetic */ HttpServletRequest val$infoHttpReq;
                {
                    this.val$infoHttpReq = httpServletRequest;
                }

                @Override
                public HttpServletResponse getHttpResponse() {
                    return (HttpServletResponse)servletResponse;
                }

                @Override
                public HttpServletRequest getHttpRequest() {
                    return this.val$infoHttpReq;
                }
            }, new ResultCallStrategy(new DefaultCallStrategy(), this.defineList), null);
        }
        catch (Throwable target) {
            if (target instanceof ServletException) {
                throw (ServletException)target;
            }
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new ServletException(target);
        }
    }

    public RequestDispatcher getReqDispatcher(final String newRequestUri, HttpServletRequest request) {
        final MappingDefine define = this.rootController.findMapping(new FindMapping(newRequestUri, request.getMethod()));
        if (define == null) {
            return null;
        }
        return new RequestDispatcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                servletRequest.setAttribute(ControllerFilter.REQUEST_DISPATCHER_REQUEST, (Object)Boolean.TRUE);
                try {
                    ControllerFilter.this.doInvoke(define, servletRequest, servletResponse);
                }
                finally {
                    servletRequest.removeAttribute(ControllerFilter.REQUEST_DISPATCHER_REQUEST);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                if (servletResponse.isCommitted()) {
                    throw new ServletException("Response has been committed--you can only call forward before committing the response (hint: don't flush buffers)");
                }
                servletResponse.resetBuffer();
                Object requestToProcess = servletRequest instanceof HttpServletRequest ? new RequestDispatcherRequestWrapper(servletRequest, newRequestUri) : servletRequest;
                servletRequest.setAttribute(ControllerFilter.REQUEST_DISPATCHER_REQUEST, (Object)Boolean.TRUE);
                try {
                    ControllerFilter.this.doInvoke(define, requestToProcess, servletResponse);
                }
                finally {
                    servletRequest.removeAttribute(ControllerFilter.REQUEST_DISPATCHER_REQUEST);
                }
            }
        };
    }

    private static class RequestDispatcherRequestWrapper
    extends HttpServletRequestWrapper {
        private final String newRequestUri;

        public RequestDispatcherRequestWrapper(ServletRequest servletRequest, String newRequestUri) {
            super((HttpServletRequest)servletRequest);
            this.newRequestUri = newRequestUri;
        }

        public String getRequestURI() {
            return this.newRequestUri;
        }
    }
}

