/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.mvc.strat;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.hasor.mvc.Call;
import net.hasor.mvc.CallStrategy;
import net.hasor.mvc.MappingInfo;
import net.hasor.mvc.ModelController;
import net.hasor.mvc.api.AbstractWebController;
import net.hasor.mvc.api.AttributeParam;
import net.hasor.mvc.api.CookieParam;
import net.hasor.mvc.api.HeaderParam;
import net.hasor.mvc.api.Param;
import net.hasor.mvc.api.PathParam;
import net.hasor.mvc.api.Produces;
import net.hasor.mvc.api.QueryParam;
import org.more.convert.ConverterUtils;
import org.more.logger.LoggerHelper;
import org.more.util.BeanUtils;
import org.more.util.StringUtils;

public class DefaultCallStrategy
implements CallStrategy {
    public static final CallStrategy Instance = new DefaultCallStrategy();
    private Map<String, List<String>> queryParamLocal;
    private Map<String, Object> pathParamsLocal;

    protected void initCall(Call call) {
        ModelController controller = call.getTarget();
        if (controller instanceof AbstractWebController) {
            ((AbstractWebController)controller).initController(call.getHttpRequest(), call.getHttpResponse());
        }
    }

    @Override
    public Object exeCall(Call call) throws Throwable {
        this.initCall(call);
        Object[] args = this.resolveParams(call);
        return this.returnCallBack(call.call(args), call);
    }

    protected Object returnCallBack(Object returnData, Call call) {
        Produces pro;
        String proValue;
        Method targetMethod = call.getMethod();
        if (targetMethod.isAnnotationPresent(Produces.class) && !StringUtils.isBlank((String)(proValue = (pro = targetMethod.getAnnotation(Produces.class)).value()))) {
            call.getHttpResponse().setContentType(proValue);
        }
        return returnData;
    }

    protected final Object[] resolveParams(Call call) throws Throwable {
        Method targetMethod = call.getMethod();
        Class<?>[] targetParamClass = call.getParameterTypes();
        Annotation[][] targetParamAnno = call.getMethodParamAnnos();
        targetParamClass = targetParamClass == null ? new Class[]{} : targetParamClass;
        targetParamAnno = targetParamAnno == null ? new Annotation[0][0] : targetParamAnno;
        ArrayList<Object> paramsArray = new ArrayList<Object>();
        for (int i = 0; i < targetParamClass.length; ++i) {
            Class<?> paramClass = targetParamClass[i];
            Object paramObject = this.resolveParam(paramClass, targetParamAnno[i], call);
            paramObject = paramObject == null ? BeanUtils.getDefaultValue(paramClass) : ConverterUtils.convert(paramClass, (Object)paramObject);
            paramsArray.add(paramObject);
        }
        Object[] invokeParams = paramsArray.toArray();
        return invokeParams;
    }

    private final Object resolveParam(Class<?> paramClass, Annotation[] paramAnno, Call call) {
        for (Annotation pAnno : paramAnno) {
            Object finalValue = this.resolveParam(paramClass, pAnno, call);
            if (finalValue == null) continue;
            return finalValue;
        }
        return BeanUtils.getDefaultValue(paramClass);
    }

    protected Object resolveParam(Class<?> paramClass, Annotation pAnno, Call call) {
        Object atData = null;
        if (atData == null) {
            if (pAnno instanceof AttributeParam) {
                atData = this.getAttributeParam(call, paramClass, (AttributeParam)pAnno);
            } else if (pAnno instanceof Param) {
                atData = call.getParam(((Param)pAnno).value());
            } else if (pAnno instanceof CookieParam) {
                atData = this.getCookieParam(call, paramClass, (CookieParam)pAnno);
            } else if (pAnno instanceof HeaderParam) {
                atData = this.getHeaderParam(call, paramClass, (HeaderParam)pAnno);
            } else if (pAnno instanceof QueryParam) {
                atData = this.getQueryParam(call, paramClass, (QueryParam)pAnno);
            } else if (pAnno instanceof PathParam) {
                atData = this.getPathParam(call, paramClass, (PathParam)pAnno, call.getMappingInfo());
            }
        }
        return atData;
    }

    private Object getPathParam(Call call, Class<?> paramClass, PathParam pAnno, MappingInfo mappingInfo) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : this.getPathParamMap(call, mappingInfo).get(paramName);
    }

    private Object getQueryParam(Call call, Class<?> paramClass, QueryParam pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : this.getQueryParamMap(call).get(paramName);
    }

    private Object getHeaderParam(Call call, Class<?> paramClass, HeaderParam pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = call.getHttpRequest();
        Enumeration e = httpRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!StringUtils.equalsIgnoreCase((String)name, (String)paramName)) continue;
            ArrayList headerList = new ArrayList();
            Enumeration v = httpRequest.getHeaders(paramName);
            while (v.hasMoreElements()) {
                headerList.add(v.nextElement());
            }
            return headerList;
        }
        return null;
    }

    private Object getCookieParam(Call call, Class<?> paramClass, CookieParam pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = call.getHttpRequest();
        Cookie[] cookies = httpRequest.getCookies();
        ArrayList<String> cookieList = new ArrayList<String>();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!StringUtils.equalsIgnoreCase((String)cookie.getName(), (String)paramName)) continue;
                cookieList.add(cookie.getValue());
            }
        }
        return cookieList;
    }

    private Object getAttributeParam(Call call, Class<?> paramClass, AttributeParam pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = call.getHttpRequest();
        Enumeration e = httpRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!StringUtils.equalsIgnoreCase((String)name, (String)paramName)) continue;
            return httpRequest.getAttribute(paramName);
        }
        return null;
    }

    private Map<String, List<String>> getQueryParamMap(Call call) {
        String[] params;
        if (this.queryParamLocal != null) {
            return this.queryParamLocal;
        }
        HttpServletRequest httpRequest = call.getHttpRequest();
        String queryString = httpRequest.getQueryString();
        if (StringUtils.isBlank((String)queryString)) {
            return Collections.EMPTY_MAP;
        }
        this.queryParamLocal = new HashMap<String, List<String>>();
        String[] arr$ = params = queryString.split("&");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String oriData;
            block6: {
                String pData;
                oriData = pData = arr$[i$];
                String encoding = httpRequest.getCharacterEncoding();
                try {
                    if (encoding == null) break block6;
                    oriData = URLDecoder.decode(pData, encoding);
                }
                catch (Exception e) {
                    LoggerHelper.logWarn((String)"use \u2018%s\u2019 decode \u2018%s\u2019 error.", (Object[])new Object[]{encoding, pData});
                    continue;
                }
            }
            String[] kv = oriData.split("=");
            if (kv.length < 2) continue;
            String k = kv[0].trim();
            String v = kv[1];
            ArrayList<String> pArray = this.queryParamLocal.get(k);
            ArrayList<String> arrayList = pArray = pArray == null ? new ArrayList<String>() : pArray;
            if (!pArray.contains(v)) {
                pArray.add(v);
            }
            this.queryParamLocal.put(k, pArray);
        }
        return this.queryParamLocal;
    }

    private Map<String, Object> getPathParamMap(Call call, MappingInfo mappingInfo) {
        if (this.pathParamsLocal != null) {
            return this.pathParamsLocal;
        }
        HttpServletRequest httpRequest = call.getHttpRequest();
        String requestPath = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        String matchVar = mappingInfo.getMappingToMatches();
        String matchKey = "(?:\\{(\\w+)\\}){1,}";
        Matcher keyM = Pattern.compile(matchKey).matcher(mappingInfo.getMappingTo());
        Matcher varM = Pattern.compile(matchVar).matcher(requestPath);
        ArrayList<String> keyArray = new ArrayList<String>();
        ArrayList<String> varArray = new ArrayList<String>();
        while (keyM.find()) {
            keyArray.add(keyM.group(1));
        }
        varM.find();
        for (int i = 1; i <= varM.groupCount(); ++i) {
            varArray.add(varM.group(i));
        }
        HashMap<String, List> uriParams = new HashMap<String, List>();
        for (int i = 0; i < keyArray.size(); ++i) {
            String k = (String)keyArray.get(i);
            String v = (String)varArray.get(i);
            List pArray = (List)uriParams.get(k);
            List list = pArray = pArray == null ? new ArrayList() : pArray;
            if (!pArray.contains(v)) {
                pArray.add(v);
            }
            uriParams.put(k, pArray);
        }
        this.pathParamsLocal = new HashMap<String, Object>();
        for (Map.Entry ent : uriParams.entrySet()) {
            String k = (String)ent.getKey();
            List v = (List)ent.getValue();
            this.pathParamsLocal.put(k, v.toArray(new String[v.size()]));
        }
        return this.pathParamsLocal;
    }
}

