/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class ClobReaderTypeHandler
extends AbstractTypeHandler<Reader> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Reader parameter, Integer jdbcType) throws SQLException {
        ps.setClob(i, parameter);
    }

    @Override
    public Reader getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.toReader(rs.getClob(columnName));
    }

    @Override
    public Reader getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.toReader(rs.getClob(columnIndex));
    }

    @Override
    public Reader getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.toReader(cs.getClob(columnIndex));
    }

    protected Reader toReader(Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        return clob.getCharacterStream();
    }
}

