/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.mapping.def;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.db.mapping.def.ColumnMapping;
import net.hasor.db.mapping.def.TableMapping;
import net.hasor.db.types.TypeHandlerRegistry;

public class TableDef<T>
implements TableMapping<T> {
    private String schema;
    private String table;
    private final Class<T> entityType;
    private final boolean autoProperty;
    private final boolean useDelimited;
    private final boolean caseInsensitive;
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final List<ColumnMapping> columnMappings;
    private final Map<String, ColumnMapping> mapByProperty;
    private final Map<String, ColumnMapping> mapByColumn;

    public TableDef(String schema, String table, Class<T> entityType, boolean autoProperty, boolean useDelimited, boolean caseInsensitive, TypeHandlerRegistry typeHandlerRegistry) {
        this.schema = schema;
        this.table = table;
        this.entityType = entityType;
        this.autoProperty = autoProperty;
        this.useDelimited = useDelimited;
        this.caseInsensitive = caseInsensitive;
        this.columnMappings = new ArrayList<ColumnMapping>();
        this.mapByProperty = new HashMap<String, ColumnMapping>();
        this.mapByColumn = caseInsensitive ? new LinkedCaseInsensitiveMap() : new HashMap();
        this.typeHandlerRegistry = typeHandlerRegistry;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public Class<T> entityType() {
        return this.entityType;
    }

    @Override
    public boolean isAutoProperty() {
        return this.autoProperty;
    }

    @Override
    public boolean useDelimited() {
        return this.useDelimited;
    }

    @Override
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public Collection<ColumnMapping> getProperties() {
        return this.columnMappings;
    }

    @Override
    public ColumnMapping getPropertyByColumn(String column) {
        return this.mapByColumn.get(column);
    }

    @Override
    public ColumnMapping getPropertyByName(String property) {
        return this.mapByProperty.get(property);
    }

    @Override
    public TypeHandlerRegistry getTypeHandlerRegistry() {
        return this.typeHandlerRegistry;
    }

    public void addMapping(ColumnMapping mapping) {
        String columnName = mapping.getColumn();
        String propertyName = mapping.getProperty();
        if (this.mapByColumn.containsKey(columnName) && this.mapByProperty.containsKey(propertyName)) {
            throw new IllegalStateException("mapping already added.");
        }
        this.mapByColumn.put(columnName, mapping);
        this.mapByProperty.put(propertyName, mapping);
        this.columnMappings.add(mapping);
    }
}

