/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.segment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hasor.cobble.StringUtils;
import net.hasor.db.lambda.segment.Segment;

public final class MergeSqlSegment
implements Segment {
    private final List<Segment> segments = new ArrayList<Segment>();

    public MergeSqlSegment(List<Segment> segments) {
        this.segments.addAll(segments);
    }

    public MergeSqlSegment(Segment ... segments) {
        this.segments.addAll(Arrays.asList(segments));
    }

    public void addSegment(Segment ... segmentArrays) {
        if (segmentArrays != null) {
            this.segments.addAll(Arrays.asList(segmentArrays));
        }
    }

    @Override
    public String getSqlSegment() {
        return this.getSqlSegment(this.segments);
    }

    public MergeSqlSegment sub(int form) {
        return new MergeSqlSegment(this.segments.subList(form, this.segments.size()));
    }

    public String noFirstSqlSegment() {
        return this.getSqlSegment(this.segments.subList(1, this.segments.size()));
    }

    private String getSqlSegment(List<Segment> dataList) {
        StringBuilder strBuilder = new StringBuilder("");
        for (Segment segment : dataList) {
            String str = segment.getSqlSegment();
            if (StringUtils.isNotBlank((String)str)) {
                strBuilder.append(str).append(" ");
                continue;
            }
            strBuilder.append(" ");
        }
        return strBuilder.toString().trim();
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public Segment firstSqlSegment() {
        if (this.segments.isEmpty()) {
            return null;
        }
        Segment segment = this.segments.get(0);
        if (segment instanceof MergeSqlSegment) {
            return ((MergeSqlSegment)segment).firstSqlSegment();
        }
        return segment;
    }

    public void cleanSegment() {
        this.segments.clear();
    }
}

