/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.core;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.lambda.LambdaTemplate;
import net.hasor.db.lambda.core.BasicQueryCompare;
import net.hasor.db.lambda.core.UpdateExecute;
import net.hasor.db.lambda.segment.MergeSqlSegment;
import net.hasor.db.lambda.segment.Segment;
import net.hasor.db.lambda.segment.SqlKeyword;
import net.hasor.db.mapping.def.ColumnMapping;
import net.hasor.db.mapping.def.TableMapping;

public abstract class AbstractUpdateLambda<R, T, P>
extends BasicQueryCompare<R, T, P>
implements UpdateExecute<R, T> {
    protected final Map<String, ColumnMapping> allowUpdateProperties = new LinkedHashMap<String, ColumnMapping>();
    protected final Map<String, Object> updateValueMap;
    private boolean allowEmptyWhere = false;

    public AbstractUpdateLambda(Class<?> exampleType, TableMapping<?> tableMapping, LambdaTemplate jdbcTemplate) {
        super(exampleType, tableMapping, jdbcTemplate);
        for (ColumnMapping mapping : tableMapping.getProperties()) {
            if (!mapping.isUpdate()) continue;
            this.allowUpdateProperties.put(mapping.getProperty(), mapping);
        }
        this.updateValueMap = new HashMap<String, Object>();
    }

    @Override
    public R allowEmptyWhere() {
        this.allowEmptyWhere = true;
        return this.getSelf();
    }

    @Override
    public int doUpdate() throws SQLException {
        if (this.updateValueMap.isEmpty()) {
            throw new IllegalStateException("Nothing to update.");
        }
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().executeUpdate(boundSql.getSqlString(), boundSql.getArgs());
    }

    @Override
    public R updateBySample(T newValue) {
        if (newValue == null) {
            throw new NullPointerException("newValue is null.");
        }
        HashMap<String, Object> tempData = new HashMap<String, Object>();
        for (Map.Entry<String, ColumnMapping> mappingEntry : this.allowUpdateProperties.entrySet()) {
            Object value = mappingEntry.getValue().getHandler().get(newValue);
            if (value == null) continue;
            tempData.put(mappingEntry.getKey(), value);
        }
        return this.updateToByCondition(tempData::containsKey, tempData::get);
    }

    @Override
    public R updateByMap(Map<String, Object> newValue) {
        if (newValue == null) {
            throw new NullPointerException("newValue is null.");
        }
        return this.updateToByCondition(newValue::containsKey, newValue::get);
    }

    @Override
    public R updateTo(T newValue) {
        if (newValue == null) {
            throw new NullPointerException("newValue is null.");
        }
        return this.updateToByCondition(p -> true, this.createPropertyReaderFunc(newValue));
    }

    private Function<String, Object> createPropertyReaderFunc(T newValue) {
        if (this.exampleIsMap()) {
            return ((Map)newValue)::get;
        }
        TableMapping<?> tableMapping = this.getTableMapping();
        return property -> {
            ColumnMapping propertyReader = tableMapping.getPropertyByName((String)property);
            return propertyReader == null ? null : propertyReader.getHandler().get(newValue);
        };
    }

    protected R updateToByCondition(Predicate<String> propertyTester, Function<String, Object> propertyReader) {
        this.updateValueMap.clear();
        HashSet<String> updateColumns = new HashSet<String>();
        for (Map.Entry<String, ColumnMapping> allowFieldEntry : this.allowUpdateProperties.entrySet()) {
            ColumnMapping allowProperty = allowFieldEntry.getValue();
            if (!propertyTester.test(allowProperty.getProperty())) continue;
            String columnName = allowProperty.getColumn();
            String propertyName = allowProperty.getProperty();
            if (updateColumns.contains(columnName)) {
                throw new IllegalStateException("Multiple property mapping to '" + columnName + "' column");
            }
            updateColumns.add(columnName);
            Object propertyValue = propertyReader.apply(allowProperty.getProperty());
            this.updateValueMap.put(propertyName, propertyValue);
        }
        return this.getSelf();
    }

    @Override
    protected BoundSql buildBoundSql(SqlDialect dialect) {
        if (this.updateValueMap.isEmpty()) {
            return null;
        }
        this.queryParam.clear();
        MergeSqlSegment updateTemplate = new MergeSqlSegment(new Segment[0]);
        updateTemplate.addSegment(SqlKeyword.UPDATE);
        TableMapping<?> tableMapping = this.getTableMapping();
        String schemaName = tableMapping.getSchema();
        String tableName = tableMapping.getTable();
        String table = dialect.tableName(this.isQualifier(), schemaName, tableName);
        updateTemplate.addSegment(() -> table);
        updateTemplate.addSegment(SqlKeyword.SET);
        boolean isFirstColumn = true;
        for (String propertyName : this.updateValueMap.keySet()) {
            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                updateTemplate.addSegment(() -> ",");
            }
            ColumnMapping mapping = this.allowUpdateProperties.get(propertyName);
            String columnName = dialect.columnName(this.isQualifier(), schemaName, tableName, mapping.getColumn());
            Object columnValue = this.updateValueMap.get(propertyName);
            updateTemplate.addSegment(() -> columnName, SqlKeyword.EQ, this.formatSegment(columnValue));
        }
        if (!this.queryTemplate.isEmpty()) {
            updateTemplate.addSegment(SqlKeyword.WHERE);
            updateTemplate.addSegment(this.queryTemplate.sub(1));
        } else if (!this.allowEmptyWhere) {
            throw new UnsupportedOperationException("The dangerous UPDATE operation, You must call `allowEmptyWhere()` to enable UPDATE ALL.");
        }
        String sqlQuery = updateTemplate.getSqlSegment();
        Object[] args = (Object[])this.queryParam.toArray().clone();
        return new BoundSql.BoundSqlObj(sqlQuery, args);
    }
}

