/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.core;

import java.sql.SQLException;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.lambda.LambdaTemplate;
import net.hasor.db.lambda.core.BasicQueryCompare;
import net.hasor.db.lambda.core.DeleteExecute;
import net.hasor.db.lambda.segment.MergeSqlSegment;
import net.hasor.db.lambda.segment.Segment;
import net.hasor.db.lambda.segment.SqlKeyword;
import net.hasor.db.mapping.def.TableMapping;

public abstract class AbstractDeleteLambda<R, T, P>
extends BasicQueryCompare<R, T, P>
implements DeleteExecute<R> {
    private boolean allowEmptyWhere = false;

    public AbstractDeleteLambda(Class<?> exampleType, TableMapping<?> tableMapping, LambdaTemplate jdbcTemplate) {
        super(exampleType, tableMapping, jdbcTemplate);
    }

    @Override
    public int doDelete() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().executeUpdate(boundSql.getSqlString(), boundSql.getArgs());
    }

    @Override
    public R allowEmptyWhere() {
        this.allowEmptyWhere = true;
        return this.getSelf();
    }

    @Override
    protected BoundSql buildBoundSql(SqlDialect dialect) {
        this.queryParam.clear();
        MergeSqlSegment updateTemplate = new MergeSqlSegment(new Segment[0]);
        updateTemplate.addSegment(SqlKeyword.DELETE);
        updateTemplate.addSegment(SqlKeyword.FROM);
        TableMapping<?> tableMapping = this.getTableMapping();
        String schemaName = tableMapping.getSchema();
        String tableName = tableMapping.getTable();
        updateTemplate.addSegment(() -> this.dialect().tableName(this.isQualifier(), schemaName, tableName));
        if (!this.queryTemplate.isEmpty()) {
            updateTemplate.addSegment(SqlKeyword.WHERE);
            updateTemplate.addSegment(this.queryTemplate.sub(1));
        } else if (!this.allowEmptyWhere) {
            throw new UnsupportedOperationException("The dangerous DELETE operation, You must call `allowEmptyWhere()` to enable DELETE ALL.");
        }
        String sqlQuery = updateTemplate.getSqlSegment();
        Object[] args = (Object[])this.queryParam.toArray().clone();
        return new BoundSql.BoundSqlObj(sqlQuery, args);
    }
}

