/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.paramer;

import java.util.Map;
import java.util.Objects;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.function.Property;
import net.hasor.db.jdbc.SqlParameterSource;
import net.hasor.db.jdbc.core.ParameterDisposer;

public class BeanSqlParameterSource
implements SqlParameterSource,
ParameterDisposer {
    private final Object dataBean;
    private final Map<String, Property> dataProperty;

    public BeanSqlParameterSource(Object dataBean) {
        this.dataBean = Objects.requireNonNull(dataBean);
        this.dataProperty = BeanUtils.getPropertyFunc(dataBean.getClass());
    }

    @Override
    public boolean hasValue(String paramName) {
        return this.dataProperty.containsKey(paramName);
    }

    @Override
    public Object getValue(String paramName) throws IllegalArgumentException {
        Property property = this.dataProperty.get(paramName);
        if (property == null) {
            return null;
        }
        return property.get(this.dataBean);
    }

    @Override
    public String[] getParameterNames() {
        return this.dataProperty.keySet().toArray(new String[0]);
    }

    @Override
    public void cleanupParameters() {
        if (this.dataBean instanceof ParameterDisposer) {
            ((ParameterDisposer)this.dataBean).cleanupParameters();
        }
    }
}

