/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.db.jdbc.mapper.AbstractRowMapper;
import net.hasor.db.types.TypeHandlerRegistry;

public class ColumnMapRowMapper
extends AbstractRowMapper<Map<String, Object>> {
    private final boolean caseInsensitive;

    public ColumnMapRowMapper() {
        this(true, TypeHandlerRegistry.DEFAULT);
    }

    public ColumnMapRowMapper(boolean caseInsensitive, TypeHandlerRegistry typeHandler) {
        super(typeHandler);
        this.caseInsensitive = caseInsensitive;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public final Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        Map<String, Object> mapOfColValues = this.createColumnMap(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String key = this.getColumnKey(rsmd, i);
            Object obj = this.getColumnValue(rs, i);
            if (mapOfColValues.containsKey(key)) continue;
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    protected String getColumnKey(ResultSetMetaData rsmd, int index) throws SQLException {
        String name = rsmd.getColumnLabel(index);
        if (name == null || name.length() < 1) {
            name = rsmd.getColumnName(index);
        }
        return name;
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return this.getResultSetValue(rs, index);
    }

    protected Map<String, Object> createColumnMap(int columnCount) {
        if (this.caseInsensitive) {
            return new LinkedCaseInsensitiveMap(columnCount);
        }
        return new LinkedHashMap<String, Object>();
    }
}

