/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.extractor;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.db.jdbc.CallableStatementCallback;
import net.hasor.db.jdbc.RowCallbackHandler;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.jdbc.SqlParameter;
import net.hasor.db.jdbc.extractor.ColumnMapResultSetExtractor;
import net.hasor.db.jdbc.extractor.MultipleProcessType;
import net.hasor.db.jdbc.extractor.RowCallbackHandlerResultSetExtractor;
import net.hasor.db.jdbc.extractor.RowMapperResultSetExtractor;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;

public class SimpleCallableStatementCallback
implements CallableStatementCallback<Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCallableStatementCallback.class);
    private final List<SqlParameter> declaredParameters;
    private final MultipleProcessType processType;
    private boolean resultsCaseInsensitive = false;
    private TypeHandlerRegistry typeHandler = TypeHandlerRegistry.DEFAULT;

    public SimpleCallableStatementCallback(List<SqlParameter> declaredParameters) {
        this(MultipleProcessType.ALL, declaredParameters);
    }

    public SimpleCallableStatementCallback(MultipleProcessType processType, List<SqlParameter> declaredParameters) {
        this.processType = processType;
        this.declaredParameters = declaredParameters;
    }

    public boolean isResultsCaseInsensitive() {
        return this.resultsCaseInsensitive;
    }

    public void setResultsCaseInsensitive(boolean resultsCaseInsensitive) {
        this.resultsCaseInsensitive = resultsCaseInsensitive;
    }

    public TypeHandlerRegistry getTypeHandler() {
        return this.typeHandler;
    }

    public void setTypeHandler(TypeHandlerRegistry typeHandler) {
        this.typeHandler = typeHandler;
    }

    protected Map<String, Object> createResultsMap() {
        if (this.isResultsCaseInsensitive()) {
            return new LinkedCaseInsensitiveMap();
        }
        return new LinkedHashMap<String, Object>();
    }

    @Override
    public Map<String, Object> doInCallableStatement(CallableStatement cs) throws SQLException {
        TypeHandler<?> paramTypeHandler;
        int sqlColIndex = 1;
        ArrayList<SqlParameter.ReturnSqlParameter> resultParameters = new ArrayList<SqlParameter.ReturnSqlParameter>();
        for (SqlParameter declaredParam : this.declaredParameters) {
            Integer paramJdbcType;
            if (declaredParam instanceof SqlParameter.InSqlParameter) {
                paramJdbcType = Objects.requireNonNull(((SqlParameter.InSqlParameter)declaredParam).getJdbcType(), "jdbcType must not be null");
                Object paramValue = ((SqlParameter.InSqlParameter)declaredParam).getValue();
                TypeHandler<?> paramTypeHandler2 = ((SqlParameter.InSqlParameter)declaredParam).getTypeHandler();
                paramTypeHandler2 = paramTypeHandler2 != null ? paramTypeHandler2 : TypeHandlerRegistry.DEFAULT.getTypeHandler(paramJdbcType);
                paramTypeHandler2.setParameter(cs, sqlColIndex, paramValue, paramJdbcType);
            }
            if (declaredParam instanceof SqlParameter.OutSqlParameter) {
                paramJdbcType = Objects.requireNonNull(((SqlParameter.OutSqlParameter)declaredParam).getJdbcType(), "jdbcType must not be null");
                String paramTypeName = ((SqlParameter.OutSqlParameter)declaredParam).getTypeName();
                Integer paramScale = ((SqlParameter.OutSqlParameter)declaredParam).getScale();
                if (paramTypeName != null) {
                    cs.registerOutParameter(sqlColIndex, (int)paramJdbcType, paramTypeName);
                } else if (paramScale != null) {
                    cs.registerOutParameter(sqlColIndex, (int)paramJdbcType, (int)paramScale);
                } else {
                    cs.registerOutParameter(sqlColIndex, (int)paramJdbcType);
                }
            }
            if (declaredParam instanceof SqlParameter.ReturnSqlParameter) {
                resultParameters.add((SqlParameter.ReturnSqlParameter)declaredParam);
            }
            ++sqlColIndex;
        }
        Map<String, Object> resultMap = this.createResultsMap();
        boolean retVal = cs.execute();
        if (logger.isTraceEnabled()) {
            logger.trace("CallableStatement.execute() returned '" + retVal + "'");
        }
        for (int i = 1; i <= this.declaredParameters.size(); ++i) {
            SqlParameter declaredParam = this.declaredParameters.get(i - 1);
            SqlParameter.OutSqlParameter outParameter = null;
            if (!(declaredParam instanceof SqlParameter.OutSqlParameter)) continue;
            outParameter = (SqlParameter.OutSqlParameter)declaredParam;
            String paramName = declaredParam.getName();
            Integer paramJdbcType = Objects.requireNonNull(outParameter.getJdbcType(), "jdbcType must not be null");
            paramTypeHandler = outParameter.getTypeHandler();
            paramName = StringUtils.isNotBlank((String)paramName) ? paramName : "#out-" + i;
            paramTypeHandler = paramTypeHandler != null ? paramTypeHandler : TypeHandlerRegistry.DEFAULT.getTypeHandler(paramJdbcType);
            Object resultValue = paramTypeHandler.getResult(cs, i);
            resultMap.put(paramName, resultValue);
        }
        int resultIndex = 1;
        SqlParameter.ReturnSqlParameter sqlParameter = resultParameters.size() > 0 ? (SqlParameter.ReturnSqlParameter)resultParameters.get(0) : null;
        String resultName = "";
        Object resultValue = null;
        if (retVal) {
            ResultSet resultSet = cs.getResultSet();
            paramTypeHandler = null;
            try {
                resultName = SimpleCallableStatementCallback.resultParameterName(sqlParameter, "#result-set-" + resultIndex);
                resultValue = this.processResultSet(resultSet, sqlParameter);
            }
            catch (Throwable throwable) {
                paramTypeHandler = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (paramTypeHandler != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)paramTypeHandler)).addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        } else {
            resultName = SimpleCallableStatementCallback.resultParameterName(sqlParameter, "#update-count-" + resultIndex);
            resultValue = cs.getUpdateCount();
        }
        resultMap.put(resultName, resultValue);
        if (this.processType == MultipleProcessType.FIRST) {
            return resultMap;
        }
        while (cs.getMoreResults() || cs.getUpdateCount() != -1) {
            if (this.processType == MultipleProcessType.ALL && StringUtils.isNotBlank((String)resultName)) {
                resultMap.put(resultName, resultValue);
            }
            sqlParameter = resultParameters.size() > ++resultIndex ? (SqlParameter.ReturnSqlParameter)resultParameters.get(resultIndex - 1) : null;
            int updateCount = cs.getUpdateCount();
            ResultSet resultSet = cs.getResultSet();
            Throwable throwable = null;
            try {
                if (resultSet != null) {
                    resultName = SimpleCallableStatementCallback.resultParameterName(sqlParameter, "#result-set-" + resultIndex);
                    resultValue = this.processResultSet(resultSet, sqlParameter);
                    continue;
                }
                resultName = SimpleCallableStatementCallback.resultParameterName(sqlParameter, "#update-count-" + resultIndex);
                resultValue = updateCount;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resultSet == null) continue;
                if (throwable != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                resultSet.close();
            }
        }
        resultMap.put(resultName, resultValue);
        return resultMap;
    }

    private static String resultParameterName(SqlParameter.ReturnSqlParameter sqlParameter, String defaultName) {
        return sqlParameter == null || StringUtils.isBlank((String)sqlParameter.getName()) ? defaultName : sqlParameter.getName();
    }

    protected Object processResultSet(ResultSet rs, SqlParameter.ReturnSqlParameter param) throws SQLException {
        if (rs != null) {
            if (param != null) {
                if (param.getRowMapper() != null) {
                    RowMapper<?> rowMapper = param.getRowMapper();
                    return new RowMapperResultSetExtractor(rowMapper).extractData(rs);
                }
                if (param.getRowCallbackHandler() != null) {
                    RowCallbackHandler rch = param.getRowCallbackHandler();
                    new RowCallbackHandlerResultSetExtractor(rch).extractData(rs);
                    return "ResultSet returned from stored procedure was processed";
                }
                if (param.getResultSetExtractor() != null) {
                    return param.getResultSetExtractor().extractData(rs);
                }
            } else {
                return new ColumnMapResultSetExtractor(0, this.typeHandler, this.resultsCaseInsensitive).extractData(rs);
            }
        }
        return null;
    }
}

