/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hasor.db.dialect.BoundSql;

public class SqlBuilder
implements BoundSql {
    protected final StringBuilder queryString = new StringBuilder();
    protected final List<Object> argList = new ArrayList<Object>();

    public boolean lastSpaceCharacter() {
        if (this.queryString.length() == 0) {
            return true;
        }
        char charAt = this.queryString.charAt(this.queryString.length() - 1);
        return charAt == ' ' || charAt == '\n' || charAt == '\t';
    }

    public void appendSql(String sql, Object ... args) {
        this.queryString.append(sql);
        this.argList.addAll(Arrays.asList(args));
    }

    public void appendSql(String sql) {
        this.queryString.append(sql);
    }

    public void appendSql(BoundSql boundSql) {
        this.queryString.append(boundSql.getSqlString());
    }

    public void appendBuilder(BoundSql boundSql) {
        if (boundSql instanceof SqlBuilder) {
            this.queryString.append((CharSequence)((SqlBuilder)boundSql).queryString);
            this.argList.addAll(((SqlBuilder)boundSql).argList);
        } else {
            this.queryString.append(boundSql.getSqlString());
            this.argList.addAll(Arrays.asList(boundSql.getArgs()));
        }
    }

    public void appendArgs(BoundSql boundSql) {
        this.argList.addAll(Arrays.asList(boundSql.getArgs()));
    }

    @Override
    public String getSqlString() {
        return this.queryString.toString();
    }

    @Override
    public Object[] getArgs() {
        return this.argList.toArray();
    }
}

