/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.session;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hasor.cobble.CollectionUtils;

class MergedMap<K, T>
extends AbstractMap<K, T> {
    private final Map<K, T> unmerged = new HashMap<K, T>();
    private final List<Map<K, T>> merged = new ArrayList<Map<K, T>>();
    private final List<Boolean> keyLocked = new ArrayList<Boolean>();

    MergedMap() {
    }

    @Override
    public int size() {
        int size = this.unmerged.size();
        for (Map<K, T> item : this.merged) {
            size += item.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        if (!this.unmerged.isEmpty()) {
            return false;
        }
        for (Map<K, T> item : this.merged) {
            if (item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.unmerged.containsValue(value)) {
            return true;
        }
        for (Map<K, T> item : this.merged) {
            if (!item.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.unmerged.containsKey(key)) {
            return true;
        }
        for (Map<K, T> item : this.merged) {
            if (!item.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T get(Object key) {
        if (this.unmerged.containsKey(key)) {
            return this.unmerged.get(key);
        }
        for (Map<K, T> item : this.merged) {
            if (!item.containsKey(key)) continue;
            return item.get(key);
        }
        return null;
    }

    @Override
    public T put(K key, T value) {
        if (this.unmerged.containsKey(key)) {
            return this.unmerged.put(key, value);
        }
        for (Map<K, T> item : this.merged) {
            if (!item.containsKey(key)) continue;
            return item.put(key, value);
        }
        return this.unmerged.put(key, value);
    }

    @Override
    public T remove(Object key) {
        if (this.unmerged.containsKey(key)) {
            return this.unmerged.remove(key);
        }
        for (int i = 0; i < this.merged.size(); ++i) {
            Map<Object, T> item = this.merged.get(i);
            Boolean keyLocked = this.keyLocked.get(i);
            if (!item.containsKey(key) || keyLocked.booleanValue()) continue;
            if (keyLocked.booleanValue()) {
                return item.put(key, null);
            }
            return item.remove(key);
        }
        return this.unmerged.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends T> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.unmerged.clear();
        for (int i = 0; i < this.merged.size(); ++i) {
            Map<K, T> item = this.merged.get(i);
            Boolean keyLocked = this.keyLocked.get(i);
            if (keyLocked.booleanValue()) {
                Set<K> keys = item.keySet();
                for (K key : keys) {
                    item.put(key, null);
                }
                continue;
            }
            item.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> keySet = new HashSet<K>(this.unmerged.keySet());
        for (Map<K, T> item : this.merged) {
            keySet.addAll(item.keySet());
        }
        return keySet;
    }

    @Override
    public Collection<T> values() {
        ArrayList<T> keySet = new ArrayList<T>(this.unmerged.values());
        for (Map<K, T> item : this.merged) {
            keySet.addAll(item.values());
        }
        return keySet;
    }

    @Override
    public Set<Map.Entry<K, T>> entrySet() {
        Iterator basic = this.unmerged.entrySet().iterator();
        for (Map<K, T> item : this.merged) {
            basic = CollectionUtils.mergeIterator(basic, item.entrySet().iterator());
        }
        final int size = this.size();
        final Iterator finalBasic = basic;
        return new AbstractSet<Map.Entry<K, T>>(){

            @Override
            public Iterator<Map.Entry<K, T>> iterator() {
                return finalBasic;
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public void appendMap(Map<? extends K, ? extends T> object, boolean keyLocked) {
        if (object != null) {
            this.merged.add(object);
            this.keyLocked.add(keyLocked);
        }
    }
}

