/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.session;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.convert.ConverterBean;
import net.hasor.cobble.ref.BeanMap;
import net.hasor.db.dal.dynamic.DynamicSql;
import net.hasor.db.dal.execute.ExecuteProxy;
import net.hasor.db.dal.repository.DalRegistry;
import net.hasor.db.dal.repository.Param;
import net.hasor.db.dal.session.BaseMapper;
import net.hasor.db.dal.session.BaseMapperHandler;
import net.hasor.db.dal.session.DalSession;
import net.hasor.db.dal.session.MergedMap;
import net.hasor.db.dialect.PageSqlDialect;
import net.hasor.db.page.Page;
import net.hasor.db.page.PageResult;

class ExecuteInvocationHandler
implements InvocationHandler {
    private final String space;
    private final DalSession dalSession;
    private final Map<String, ExecuteProxy> dynamicSqlMap = new HashMap<String, ExecuteProxy>();
    private final Map<String, Integer> pageInfoMap = new HashMap<String, Integer>();
    private final Map<String, Map<String, Integer>> argNamesMap = new HashMap<String, Map<String, Integer>>();
    private final BaseMapperHandler mapperHandler;
    private final AtomicBoolean atomicBoolean = new AtomicBoolean(false);

    public ExecuteInvocationHandler(DalSession dalSession, Class<?> dalType, DalRegistry dalRegistry, BaseMapperHandler mapperHandler) {
        this.space = dalType.getName();
        this.dalSession = dalSession;
        this.initDynamicSqlMap(dalType, dalRegistry);
        this.mapperHandler = mapperHandler;
    }

    private void initDynamicSqlMap(Class<?> dalType, DalRegistry dalRegistry) {
        for (Method method : dalType.getMethods()) {
            String dynamicId;
            DynamicSql parseXml;
            if (method.getDeclaringClass() == BaseMapper.class || method.getDeclaringClass() == Object.class || (parseXml = dalRegistry.findDynamicSql(this.space, dynamicId = method.getName())) == null) continue;
            this.dynamicSqlMap.put(dynamicId, new ExecuteProxy(dynamicId, dalRegistry.createContext(this.space)));
            Map argNames = this.argNamesMap.computeIfAbsent(dynamicId, s -> new HashMap());
            int parameterCount = method.getParameterCount();
            Annotation[][] annotations = method.getParameterAnnotations();
            for (int i = 0; i < parameterCount; ++i) {
                String fixedName = "arg" + i;
                argNames.put(fixedName, i);
                String name = method.getParameters()[i].getName();
                if (!argNames.containsKey(name)) {
                    argNames.put(name, i);
                }
                for (Annotation paramAnno : annotations[i]) {
                    String paramName;
                    if (!(paramAnno instanceof Param) || StringUtils.isBlank((String)(paramName = ((Param)paramAnno).value())) || argNames.containsKey(paramName)) continue;
                    argNames.put(paramName, i);
                }
                if (!Page.class.isAssignableFrom(method.getParameterTypes()[i])) continue;
                this.pageInfoMap.put(dynamicId, i);
            }
        }
    }

    protected Page extractPage(String dynamicId, Object[] objects) {
        Integer integer = this.pageInfoMap.get(dynamicId);
        if (integer == null || integer < 0) {
            return null;
        }
        return (Page)objects[integer];
    }

    protected Map<String, Object> extractData(String dynamicId, Object[] objects) {
        if (objects == null || objects.length == 0) {
            return new HashMap<String, Object>();
        }
        Map<String, Integer> argNames = this.argNamesMap.get(dynamicId);
        MergedMap<String, Object> mergedMap = new MergedMap<String, Object>();
        HashMap argMap = new HashMap();
        argNames.forEach((key, idx) -> argMap.put(key, objects[idx]));
        mergedMap.appendMap(argMap, false);
        if (objects.length == 1) {
            if (objects[0] instanceof Map) {
                mergedMap.appendMap((Map)objects[0], true);
            } else if (!(objects[0] instanceof Collection)) {
                BeanMap beanMap = new BeanMap(objects[0]);
                beanMap.setTransformConvert(ConverterBean.getInstance());
                mergedMap.appendMap((Map<String, Object>)beanMap, true);
            }
        }
        return mergedMap;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        if (this.mapperHandler != null && method.getDeclaringClass() == BaseMapper.class) {
            return method.invoke((Object)this.mapperHandler, objects);
        }
        String dynamicId = method.getName();
        Page page = this.extractPage(dynamicId, objects);
        boolean pageResult = method.getReturnType() == PageResult.class;
        Map<String, Object> data = this.extractData(dynamicId, objects);
        ExecuteProxy execute = this.dynamicSqlMap.get(dynamicId);
        if (execute == null) {
            throw new NoSuchMethodException("method '" + method.getDeclaringClass().getName() + "." + method.getName() + "' does not exist in mapper.");
        }
        PageSqlDialect dialect = this.dalSession.getDialect();
        Object result = this.dalSession.lambdaTemplate().execute(con -> execute.execute(con, data, page, pageResult, dialect));
        Class<?> returnType = method.getReturnType();
        if (List.class == returnType || Collection.class == returnType || Iterable.class == returnType) {
            if (result instanceof List) {
                return result;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(result);
            return list;
        }
        if (Map.class == returnType) {
            if (result instanceof Map) {
                return result;
            }
            if (result instanceof Iterable) {
                HashMap map = new HashMap();
                int i = 0;
                for (Object obj : (Iterable)result) {
                    map.put("result-" + i++, obj);
                }
                return map;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("result", result);
            return map;
        }
        if (result instanceof List) {
            int nrOfColumns = ((List)result).size();
            if (nrOfColumns > 1) {
                throw new SQLException("Incorrect row count: expected 1, actual " + nrOfColumns);
            }
            return ((List)result).get(0);
        }
        return result;
    }
}

