/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.repository.config;

import net.hasor.cobble.StringUtils;
import net.hasor.db.dal.dynamic.DynamicSql;
import net.hasor.db.dal.dynamic.nodes.ArrayDynamicSql;
import net.hasor.db.dal.dynamic.nodes.SelectKeyDynamicSql;
import net.hasor.db.dal.repository.QueryType;
import net.hasor.db.dal.repository.ResultSetType;
import net.hasor.db.dal.repository.StatementType;
import net.hasor.db.dal.repository.config.SegmentSqlConfig;
import net.hasor.db.dal.repository.config.SelectKeySqlConfig;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class DmlSqlConfig
extends SegmentSqlConfig {
    private StatementType statementType = StatementType.Prepared;
    private int timeout = -1;
    private SelectKeySqlConfig selectKey;

    public DmlSqlConfig(DynamicSql target) {
        super(target);
        this.processSelectKey(target);
    }

    public DmlSqlConfig(DynamicSql target, Node operationNode) {
        super(target);
        NamedNodeMap nodeAttributes = operationNode.getAttributes();
        Node statementTypeNode = nodeAttributes.getNamedItem("statementType");
        Node timeoutNode = nodeAttributes.getNamedItem("timeout");
        String statementType = statementTypeNode != null ? statementTypeNode.getNodeValue() : null;
        String timeout = timeoutNode != null ? timeoutNode.getNodeValue() : null;
        this.statementType = StatementType.valueOfCode(statementType, StatementType.Prepared);
        this.timeout = StringUtils.isBlank((String)timeout) ? -1 : Integer.parseInt(timeout);
        this.processSelectKey(target);
    }

    protected void processSelectKey(DynamicSql target) {
        if (target instanceof ArrayDynamicSql) {
            for (DynamicSql dynamicSql : ((ArrayDynamicSql)target).getSubNodes()) {
                if (!(dynamicSql instanceof SelectKeyDynamicSql)) continue;
                SelectKeyDynamicSql skDynamicSql = (SelectKeyDynamicSql)dynamicSql;
                StatementType skStatementType = StatementType.valueOfCode(skDynamicSql.getStatementType(), StatementType.Prepared);
                ResultSetType skResultSetType = ResultSetType.valueOfCode(skDynamicSql.getResultSetType(), ResultSetType.DEFAULT);
                this.selectKey = new SelectKeySqlConfig(skDynamicSql);
                this.selectKey.setStatementType(skStatementType);
                this.selectKey.setTimeout(skDynamicSql.getTimeout());
                this.selectKey.setResultMap(skDynamicSql.getResultMap());
                this.selectKey.setResultType(skDynamicSql.getResultType());
                this.selectKey.setFetchSize(skDynamicSql.getFetchSize());
                this.selectKey.setResultSetType(skResultSetType);
                this.selectKey.setKeyProperty(skDynamicSql.getKeyProperty());
                this.selectKey.setKeyColumn(skDynamicSql.getKeyColumn());
                this.selectKey.setOrder(skDynamicSql.getOrder());
                this.selectKey.setHandler(skDynamicSql.getHandler());
            }
        }
    }

    public SelectKeySqlConfig getSelectKey() {
        return this.selectKey;
    }

    @Override
    public abstract QueryType getDynamicType();

    public StatementType getStatementType() {
        return this.statementType;
    }

    public void setStatementType(StatementType statementType) {
        this.statementType = statementType;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

