/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.repository;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.hasor.cobble.ClassUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.reflect.resolvable.ResolvableType;
import net.hasor.db.dal.dynamic.DynamicContext;
import net.hasor.db.dal.dynamic.DynamicSql;
import net.hasor.db.dal.dynamic.rule.RuleRegistry;
import net.hasor.db.dal.repository.DalMapper;
import net.hasor.db.dal.repository.Query;
import net.hasor.db.dal.repository.RefMapper;
import net.hasor.db.dal.repository.config.QuerySqlConfig;
import net.hasor.db.dal.repository.parser.ClassDynamicResolve;
import net.hasor.db.dal.repository.parser.DynamicResolve;
import net.hasor.db.dal.repository.parser.XmlDynamicResolve;
import net.hasor.db.dal.repository.parser.XmlTableMappingResolve;
import net.hasor.db.dal.session.BaseMapper;
import net.hasor.db.mapping.TableReader;
import net.hasor.db.mapping.def.TableDef;
import net.hasor.db.mapping.def.TableMapping;
import net.hasor.db.mapping.reader.DynamicTableReader;
import net.hasor.db.mapping.resolve.ClassTableMappingResolve;
import net.hasor.db.mapping.resolve.MappingOptions;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DalRegistry {
    public static final DalRegistry DEFAULT = new DalRegistry(null, null, null, MappingOptions.buildNew());
    private final Map<String, Map<String, DynamicSql>> dynamicMap = new ConcurrentHashMap<String, Map<String, DynamicSql>>();
    private final Map<String, Map<String, TableMapping<?>>> tableMappingMap = new ConcurrentHashMap();
    private final Map<String, TableReader<?>> typeHandlerCache = new ConcurrentHashMap();
    private final ClassLoader classLoader;
    private final TypeHandlerRegistry typeRegistry;
    private final RuleRegistry ruleRegistry;
    private final MappingOptions mappingOptions;
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    public DalRegistry() {
        this(null, null, null, null);
    }

    public DalRegistry(ClassLoader classLoader, TypeHandlerRegistry typeRegistry, RuleRegistry ruleRegistry, MappingOptions mappingOptions) {
        this.classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        this.typeRegistry = typeRegistry == null ? TypeHandlerRegistry.DEFAULT : typeRegistry;
        this.ruleRegistry = ruleRegistry == null ? RuleRegistry.DEFAULT : ruleRegistry;
        this.mappingOptions = new MappingOptions(mappingOptions);
        for (String javaType : this.typeRegistry.getHandlerJavaTypes()) {
            TypeHandler<?> typeHandler = this.typeRegistry.getTypeHandler(javaType);
            TableReader<Object> tableReader = (columns, rs, rowNum) -> typeHandler.getResult(rs, 1);
            this.typeHandlerCache.put(javaType, tableReader);
        }
        boolean caseInsensitive = this.mappingOptions.getCaseInsensitive() == null || Boolean.TRUE.equals(this.mappingOptions.getCaseInsensitive());
        this.typeHandlerCache.put(Map.class.getName(), new DynamicTableReader(caseInsensitive, this.typeRegistry));
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public TypeHandlerRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public RuleRegistry getRuleRegistry() {
        return this.ruleRegistry;
    }

    public DynamicContext createContext(String space) {
        return new DalContext(space, this);
    }

    public MappingOptions cloneOptions() {
        return MappingOptions.buildNew(this.mappingOptions);
    }

    public DynamicSql findDynamicSql(Class<?> space, String dynamicId) {
        return this.findDynamicSql(space == null ? null : space.getName(), dynamicId);
    }

    public DynamicSql findDynamicSql(String space, String dynamicId) {
        Map<String, DynamicSql> dynamicSqlMap = this.dynamicMap.get(space);
        if (dynamicSqlMap == null) {
            return null;
        }
        return dynamicSqlMap.get(dynamicId);
    }

    public <T> TableMapping<T> findTableMapping(String space, String mapName) {
        Map<String, TableMapping<?>> resultMap = this.tableMappingMap.get(space = StringUtils.isBlank((String)space) ? "" : space);
        if (resultMap != null && resultMap.containsKey(mapName)) {
            return resultMap.get(mapName);
        }
        if (StringUtils.isNotBlank((String)space)) {
            return this.findTableMapping("", mapName);
        }
        return this != DEFAULT ? DEFAULT.findTableMapping(space, mapName) : null;
    }

    public <T> TableMapping<T> findTableMapping(String space, Class<?> mapType) {
        String[] names;
        space = StringUtils.isBlank((String)space) ? "" : space;
        for (String name : names = new String[]{mapType.getName(), mapType.getSimpleName(), StringUtils.firstCharToLowerCase((String)mapType.getSimpleName())}) {
            TableMapping<T> mapping = this.findTableMapping(space, name);
            if (mapping == null) continue;
            return mapping;
        }
        Map<String, TableMapping<?>> resultMap = this.tableMappingMap.get(space);
        if (resultMap == null) {
            return null;
        }
        List mappings = resultMap.values().stream().filter(tableMapping -> mapType.isAssignableFrom(tableMapping.entityType())).collect(Collectors.toList());
        if (mappings.size() == 1) {
            return (TableMapping)mappings.get(0);
        }
        if (mappings.size() > 1) {
            throw new NoSuchElementException("type '" + mapType.getName() + "' automatic choose failure, there are multiple matches.");
        }
        return null;
    }

    protected <T> TableReader<T> findTableReader(String scope, String entityType) {
        TableMapping<T> tableMapping = this.findTableMapping(scope, entityType);
        if (tableMapping != null) {
            return tableMapping.toReader();
        }
        if (this.typeHandlerCache.containsKey(entityType)) {
            return this.typeHandlerCache.get(entityType);
        }
        return this != DEFAULT ? DEFAULT.findTableReader(scope, entityType) : null;
    }

    public void loadMapper(URL resource) throws IOException {
        try (InputStream stream = resource.openStream();){
            Objects.requireNonNull(stream, "resource '" + resource + "' is not exist.");
            this.loadMapper(stream);
        }
    }

    public void loadMapper(String resource) throws IOException {
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        try (InputStream stream = this.classLoader.getResourceAsStream(resource);){
            Objects.requireNonNull(stream, "resource '" + resource + "' is not exist.");
            this.loadMapper(stream);
        }
    }

    public void loadMapper(InputStream stream) throws IOException {
        Objects.requireNonNull(stream, "load InputStream is null.");
        try {
            Node namespaceNode;
            Element root = this.loadXmlRoot(stream);
            NamedNodeMap rootAttributes = root.getAttributes();
            String namespace = "";
            if (rootAttributes != null && (namespaceNode = rootAttributes.getNamedItem("namespace")) != null && StringUtils.isBlank((String)namespace)) {
                namespace = namespaceNode.getNodeValue();
            }
            MappingOptions options = MappingOptions.resolveOptions(root, this.mappingOptions);
            this.loadReader(namespace, root, options);
            this.loadDynamic(namespace, root, options);
        }
        catch (ClassNotFoundException | ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    public void loadMapper(Class<?> refRepository) throws IOException {
        Annotation[] annotations;
        if (!refRepository.isInterface()) {
            throw new UnsupportedOperationException("the '" + refRepository.getName() + "' must interface.");
        }
        String namespace = refRepository.getName();
        boolean simpleMapper = false;
        for (Annotation annotation : annotations = refRepository.getDeclaredAnnotations()) {
            if (!(annotation instanceof DalMapper) && annotation.annotationType().getAnnotation(DalMapper.class) == null) continue;
            simpleMapper = true;
            break;
        }
        if (!simpleMapper) {
            throw new UnsupportedOperationException("type '" + refRepository.getName() + "' need @RefMapper or @SimpleMapper or @DalMapper");
        }
        RefMapper refMapper = refRepository.getAnnotation(RefMapper.class);
        if (refMapper != null) {
            String resource = refMapper.value();
            if (resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            if (StringUtils.isBlank((String)resource) && !ClassDynamicResolve.matchType(refRepository)) {
                return;
            }
            if (StringUtils.isNotBlank((String)resource)) {
                try {
                    Throwable throwable = null;
                    try (InputStream stream = this.classLoader.getResourceAsStream(resource);){
                        if (stream == null) {
                            throw new FileNotFoundException("not found mapper file '" + resource + "'");
                        }
                        Element root = this.loadXmlRoot(stream);
                        MappingOptions options = MappingOptions.resolveOptions(root, this.mappingOptions);
                        this.loadReader(namespace, root, options);
                        this.loadDynamic(namespace, root, options);
                    }
                    catch (Throwable root) {
                        Throwable throwable2 = root;
                        throw root;
                    }
                }
                catch (ClassNotFoundException | ParserConfigurationException | SAXException e) {
                    throw new IOException(e);
                }
            }
        }
        Method[] dalTypeMethods = refRepository.getMethods();
        DynamicResolve<Method> resolve = this.getMethodDynamicResolve();
        for (Method method : dalTypeMethods) {
            if (!ClassDynamicResolve.matchMethod(method)) continue;
            Class<?> resultType = null;
            for (Annotation anno : method.getAnnotations()) {
                if (!(anno instanceof Query)) continue;
                resultType = ((Query)anno).resultType();
                break;
            }
            Class<?> clazz = resultType = resultType == Object.class ? null : resultType;
            if (resultType != null && this.findTableReader(namespace, resultType.getName()) == null) {
                this.loadAsMapping(namespace, resultType);
            }
            String identify = method.getName();
            DynamicSql dynamicSql = resolve.parseSqlConfig(method);
            if (dynamicSql == null) continue;
            this.saveDynamic(namespace, identify, dynamicSql);
        }
        if (BaseMapper.class.isAssignableFrom(refRepository)) {
            ResolvableType resolvableType = ResolvableType.forClass(refRepository).as(BaseMapper.class);
            Class[] generics = resolvableType.resolveGenerics(Object.class);
            Class entityType = generics[0];
            Class clazz = entityType = entityType == Object.class ? null : entityType;
            if (entityType != null && this.findTableReader(namespace, entityType.getName()) == null) {
                this.loadAsMapping(namespace, entityType);
            }
        }
    }

    public <T> TableMapping<T> loadAsMapping(String space, Class<T> entityType) {
        if (entityType.isInterface() || entityType.isArray() || entityType.isEnum() || entityType.isPrimitive()) {
            throw new UnsupportedOperationException("entityType " + entityType.getName() + " must is pojo.");
        }
        TableDef<?> tableDef = this.getClassTableMappingResolve().resolveTableMapping(entityType, entityType.getClassLoader(), this.getTypeRegistry(), this.mappingOptions);
        this.saveMapping(space, entityType.getName(), tableDef);
        return tableDef;
    }

    private void loadReader(String space, Element configRoot, MappingOptions options) throws IOException, ClassNotFoundException {
        NodeList childNodes = configRoot.getChildNodes();
        XmlTableMappingResolve resolve = this.getXmlTableMappingResolve();
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            boolean isResultMap;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1 || !(isResultMap = "resultMap".equalsIgnoreCase(node.getNodeName()))) continue;
            NamedNodeMap nodeAttributes = node.getAttributes();
            Node idNode = nodeAttributes.getNamedItem("id");
            Node typeNode = nodeAttributes.getNamedItem("type");
            String idString = idNode != null ? idNode.getNodeValue() : null;
            String typeString = typeNode != null ? typeNode.getNodeValue() : null;
            String mapperSpace = space;
            if (StringUtils.isBlank((String)typeString)) {
                throw new IOException("the <resultMap> tag, type is null.");
            }
            String string = mapperSpace = StringUtils.isBlank((String)mapperSpace) ? "" : mapperSpace;
            if (StringUtils.isBlank((String)idString)) {
                idString = typeString;
            }
            TableMapping<?> tableMapping = resolve.resolveTableMapping(node, this.getClassLoader(), this.getTypeRegistry(), options);
            this.saveMapping(mapperSpace, idString, tableMapping);
        }
    }

    private void loadDynamic(String scope, Element configRoot, MappingOptions options) throws IOException, ClassNotFoundException {
        NodeList childNodes = configRoot.getChildNodes();
        DynamicResolve<Node> resolve = this.getXmlDynamicResolve();
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            String idString;
            Node node = childNodes.item(i);
            String elementName = node.getNodeName();
            if (node.getNodeType() != 1 || "resultMap".equalsIgnoreCase(elementName)) continue;
            NamedNodeMap nodeAttributes = node.getAttributes();
            Node idNode = nodeAttributes.getNamedItem("id");
            String string = idString = idNode != null ? idNode.getNodeValue() : null;
            if (StringUtils.isBlank((String)idString)) {
                throw new IOException("the <" + node.getNodeName() + "> tag is missing an ID.");
            }
            DynamicSql dynamicSql = resolve.parseSqlConfig(node);
            if (dynamicSql instanceof QuerySqlConfig) {
                String resultMap = ((QuerySqlConfig)dynamicSql).getResultMap();
                String resultType = ((QuerySqlConfig)dynamicSql).getResultType();
                if (StringUtils.isNotBlank((String)resultMap)) {
                    String[] tableMappings;
                    for (String mapping : tableMappings = resultMap.split(",")) {
                        if (this.findTableMapping(scope, mapping) != null) continue;
                        throw new IOException("loadMapper failed, '" + idString + "', resultMap '" + resultMap + "' is undefined ,resource '" + scope + "'");
                    }
                }
                if (StringUtils.isNotBlank((String)resultType)) {
                    String[] resultTypes;
                    for (String type : resultTypes = resultType.split(",")) {
                        if (this.findTableReader(scope, type) != null) continue;
                        Class resultClass = ClassUtils.getClass((ClassLoader)this.getClassLoader(), (String)type);
                        this.loadReaderByType(resultClass, options);
                    }
                }
            }
            if (dynamicSql == null) continue;
            this.saveDynamic(scope, idString, dynamicSql);
        }
    }

    protected TableReader<?> loadReaderByType(Class<?> resultClass, MappingOptions options) throws IOException {
        if (this.typeHandlerCache.containsKey(resultClass.getName())) {
            return this.typeHandlerCache.get(resultClass.getName());
        }
        TableReader<Object> tableReader = null;
        if (this.typeRegistry.hasTypeHandler(resultClass)) {
            TypeHandler<?> typeHandler = this.typeRegistry.getTypeHandler(resultClass);
            tableReader = (columns, rs, rowNum) -> typeHandler.getResult(rs, 1);
        } else {
            tableReader = this.getClassTableMappingResolve().resolveTableMapping(resultClass, resultClass.getClassLoader(), this.getTypeRegistry(), options).toReader();
        }
        if (tableReader == null) {
            throw new IOException("loadReaderByType failed, entityType '" + resultClass.getName() + "' can not resolve.");
        }
        this.typeHandlerCache.put(resultClass.getName(), tableReader);
        return tableReader;
    }

    protected void saveMapping(String space, String identify, TableMapping<?> tableMapping) {
        Map<String, TableMapping<?>> mappingMap;
        String string = space = StringUtils.isBlank((String)space) ? "" : space;
        if (!this.tableMappingMap.containsKey(space)) {
            this.tableMappingMap.put(space, new ConcurrentHashMap());
        }
        if ((mappingMap = this.tableMappingMap.get(space)).containsKey(identify)) {
            throw new IllegalStateException("repeat resultMap '" + identify + "' in " + (StringUtils.isBlank((String)space) ? "default namespace" : "'" + space + "' namespace."));
        }
        mappingMap.put(identify, tableMapping);
    }

    protected void saveDynamic(String space, String identify, DynamicSql dynamicSql) throws IOException {
        Map<String, DynamicSql> sqlMap;
        if (identify.contains(".")) {
            throw new IllegalStateException("identify cannot contain the character '.'");
        }
        if (!this.dynamicMap.containsKey(space)) {
            this.dynamicMap.put(space, new ConcurrentHashMap());
        }
        if ((sqlMap = this.dynamicMap.get(space)).containsKey(identify)) {
            throw new IOException("repeat '" + identify + "' in " + (StringUtils.isBlank((String)space) ? "default namespace" : "'" + space + "' namespace."));
        }
        sqlMap.put(identify, dynamicSql);
    }

    protected Element loadXmlRoot(InputStream stream) throws ParserConfigurationException, IOException, SAXException {
        if (stream == null) {
            throw new NullPointerException("stream is null.");
        }
        DocumentBuilder documentBuilder = FACTORY.newDocumentBuilder();
        documentBuilder.setEntityResolver((publicId, systemId) -> {
            boolean mybatisDTD;
            boolean hasorDTD = StringUtils.equalsIgnoreCase((String)"-//hasor.net//DTD Mapper 1.0//EN", (String)publicId) || StringUtils.containsIgnoreCase((String)systemId, (String)"hasordb-mapper.dtd");
            boolean bl = mybatisDTD = StringUtils.equalsIgnoreCase((String)"-//mybatis.org//DTD Mapper 3.0//EN", (String)publicId) || StringUtils.containsIgnoreCase((String)systemId, (String)"mybatis-3-mapper.dtd");
            if (hasorDTD) {
                InputSource source = new InputSource(this.getClassLoader().getResourceAsStream("net/hasor/db/dal/repository/parser/hasordb-mapper.dtd"));
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
            if (mybatisDTD) {
                InputSource source = new InputSource(this.getClassLoader().getResourceAsStream("net/hasor/db/dal/repository/parser/mybatis-3-mapper.dtd"));
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
            return new DefaultHandler().resolveEntity(publicId, systemId);
        });
        Document document = documentBuilder.parse(new InputSource(stream));
        return document.getDocumentElement();
    }

    protected XmlTableMappingResolve getXmlTableMappingResolve() {
        return new XmlTableMappingResolve();
    }

    protected ClassTableMappingResolve getClassTableMappingResolve() {
        return new ClassTableMappingResolve();
    }

    protected DynamicResolve<Method> getMethodDynamicResolve() {
        return new ClassDynamicResolve();
    }

    protected DynamicResolve<Node> getXmlDynamicResolve() {
        return new XmlDynamicResolve();
    }

    private static class DalContext
    extends DynamicContext {
        private final String space;
        private final DalRegistry dalRegistry;

        public DalContext(String space, DalRegistry dalRegistry) {
            this.space = space;
            this.dalRegistry = dalRegistry;
        }

        @Override
        public DynamicSql findDynamic(String dynamicId) {
            return this.dalRegistry.findDynamicSql(this.space, dynamicId);
        }

        @Override
        public TableMapping<?> findTableMapping(String resultMap) {
            return this.dalRegistry.findTableMapping(this.space, resultMap);
        }

        @Override
        public TableReader<?> findTableReader(String resultType) {
            return this.dalRegistry.findTableReader(this.space, resultType);
        }

        @Override
        public TypeHandlerRegistry getTypeRegistry() {
            return this.dalRegistry.getTypeRegistry();
        }

        @Override
        public RuleRegistry getRuleRegistry() {
            return this.dalRegistry.getRuleRegistry();
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.dalRegistry.getClassLoader();
        }
    }
}

