/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.execute.sequence;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.db.dal.execute.AbstractStatementExecute;
import net.hasor.db.dal.execute.KeySequenceHolder;
import net.hasor.db.dal.execute.KeySequenceHolderFactory;
import net.hasor.db.dal.repository.config.SelectKeySqlConfig;

public class SelectKeySequenceHolderFactory
implements KeySequenceHolderFactory {
    @Override
    public KeySequenceHolder createHolder(SelectKeySqlConfig keySqlConfig, AbstractStatementExecute<?> selectKeyExecute) {
        return new SelectKeySequenceHolder(keySqlConfig, selectKeyExecute);
    }

    private static class SelectKeySequenceHolder
    implements KeySequenceHolder {
        private final SelectKeySqlConfig keySqlConfig;
        private final AbstractStatementExecute<?> selectKeyExecute;

        public SelectKeySequenceHolder(SelectKeySqlConfig keySqlConfig, AbstractStatementExecute<?> selectKeyExecute) {
            this.keySqlConfig = keySqlConfig;
            this.selectKeyExecute = selectKeyExecute;
        }

        @Override
        public Object processSelectKey(Connection conn, Map<String, Object> parameter) throws SQLException {
            String keyColumn = this.keySqlConfig.getKeyColumn();
            Object resultValue = null;
            resultValue = StringUtils.isBlank((String)keyColumn) ? this.selectKeyExecute.execute(conn, this.keySqlConfig, parameter, null, false, null) : this.selectKeyExecute.execute(conn, this.keySqlConfig, parameter, null, false, null, true);
            if (resultValue instanceof List) {
                resultValue = ((List)resultValue).get(0);
            }
            return resultValue;
        }
    }
}

