/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.execute;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.convert.ConverterBean;
import net.hasor.cobble.ref.BeanMap;
import net.hasor.db.dal.execute.KeySequenceHolder;
import net.hasor.db.dal.repository.config.SelectKeySqlConfig;

public class KeySequenceExecute {
    private final SelectKeySqlConfig keySqlConfig;
    private final KeySequenceHolder sequenceHolder;

    public KeySequenceExecute(SelectKeySqlConfig keySqlConfig, KeySequenceHolder sequenceHolder) {
        this.keySqlConfig = keySqlConfig;
        this.sequenceHolder = sequenceHolder;
    }

    public void processBefore(Connection conn, Map<String, Object> parameter) throws SQLException {
        if (StringUtils.equalsIgnoreCase((String)"BEFORE", (String)this.keySqlConfig.getOrder())) {
            this.processSelectKey(conn, parameter);
        }
    }

    public void processAfter(Connection conn, Map<String, Object> parameter) throws SQLException {
        if (StringUtils.equalsIgnoreCase((String)"AFTER", (String)this.keySqlConfig.getOrder())) {
            this.processSelectKey(conn, parameter);
        }
    }

    public void processSelectKey(Connection conn, Map<String, Object> parameter) throws SQLException {
        String keyColumn = this.keySqlConfig.getKeyColumn();
        String keyProperty = this.keySqlConfig.getKeyProperty();
        Object resultValue = this.sequenceHolder.processSelectKey(conn, parameter);
        if (resultValue instanceof List) {
            resultValue = ((List)resultValue).get(0);
        }
        if (StringUtils.isNotBlank((String)keyColumn)) {
            String[] columns;
            String[] properties = keyProperty.split(",");
            if (properties.length != (columns = keyColumn.split(",")).length) {
                throw new SQLException("SelectKey keyProperty size " + properties.length + " and keyColumn size " + columns.length + ", mismatch.");
            }
            Map keyResult = null;
            if (resultValue instanceof Map) {
                keyResult = (Map)resultValue;
            } else {
                BeanMap beanMap = new BeanMap(resultValue);
                beanMap.setTransformConvert(ConverterBean.getInstance());
                keyResult = beanMap;
            }
            for (int i = 0; i < columns.length; ++i) {
                parameter.put(properties[i], keyResult.get(columns[i]));
            }
        } else {
            String[] properties = keyProperty.split(",");
            if (properties.length > 1) {
                throw new SQLException("SelectKey multiple property, keyColumn must be config.");
            }
            if (resultValue instanceof Map) {
                resultValue = ((Map)resultValue).values().stream().findFirst().orElse(null);
            }
            parameter.put(properties[0], resultValue);
        }
    }
}

