/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.dynamic.rule;

import java.util.Map;
import net.hasor.db.dal.dynamic.DynamicContext;
import net.hasor.db.dal.dynamic.SqlArg;
import net.hasor.db.dal.dynamic.SqlMode;
import net.hasor.db.dal.dynamic.ognl.OgnlUtils;
import net.hasor.db.dal.dynamic.rule.SqlBuildRule;
import net.hasor.db.dialect.SqlBuilder;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;

public class OgnlRule
implements SqlBuildRule {
    public static final SqlBuildRule INSTANCE = new OgnlRule();
    private static final TypeHandler<?> stringTypeHandler = TypeHandlerRegistry.DEFAULT.getTypeHandler(String.class);

    @Override
    public void executeRule(Map<String, Object> data, DynamicContext context, SqlBuilder sqlBuilder, String activeExpr, String ruleValue) {
        Object evalOgnl = OgnlUtils.evalOgnl(ruleValue, data);
        SqlArg sqlArg = null;
        if (evalOgnl == null) {
            sqlArg = new SqlArg(ruleValue, null, SqlMode.In, 0, String.class, stringTypeHandler);
        } else {
            Class<?> argType = evalOgnl.getClass();
            int sqlType = TypeHandlerRegistry.toSqlType(argType);
            TypeHandler<?> typeHandler = context.getTypeRegistry().getTypeHandler(argType);
            sqlArg = new SqlArg(ruleValue, null, SqlMode.In, sqlType, argType, typeHandler);
        }
        sqlBuilder.appendSql("?", sqlArg);
    }

    public String toString() {
        return "net.hasor.db.jars.ognl [" + this.hashCode() + "]";
    }
}

