/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.cobble.reflect.TypeReference;
import net.hasor.db.types.TypeHandler;

public abstract class AbstractTypeHandler<T>
extends TypeReference<T>
implements TypeHandler<T> {
    @Override
    public void setParameter(PreparedStatement ps, int i, T parameter, Integer jdbcType) throws SQLException {
        if (parameter == null) {
            if (jdbcType == null) {
                throw new SQLException("JDBC requires that the JdbcType must be specified for all nullable parameters.");
            }
            try {
                ps.setNull(i, jdbcType);
            }
            catch (SQLException e) {
                throw new SQLException("Error setting null for parameter #" + i + " with JdbcType " + jdbcType + ", Try setting a different JdbcType for this parameter or a different jdbcTypeForNull configuration property. Cause: " + e.getMessage(), e);
            }
        }
        try {
            this.setNonNullParameter(ps, i, parameter, jdbcType);
        }
        catch (Exception e) {
            throw new SQLException("Error setting non null for parameter #" + i + " with JdbcType " + jdbcType + ",Try setting a different JdbcType for this parameter or a different configuration property. Cause: " + e.getMessage(), e);
        }
    }

    @Override
    public T getResult(ResultSet rs, String columnName) throws SQLException {
        try {
            return this.getNullableResult(rs, columnName);
        }
        catch (Exception e) {
            throw new SQLException("Error attempting to get column '" + columnName + "' from result set.  Cause: " + e.getMessage(), e);
        }
    }

    @Override
    public T getResult(ResultSet rs, int columnIndex) throws SQLException {
        try {
            return this.getNullableResult(rs, columnIndex);
        }
        catch (Exception e) {
            throw new SQLException("Error attempting to get column #" + columnIndex + " from result set.  Cause: " + e.getMessage(), e);
        }
    }

    @Override
    public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
        try {
            return this.getNullableResult(cs, columnIndex);
        }
        catch (Exception e) {
            throw new SQLException("Error attempting to get column #" + columnIndex + " from callable statement.  Cause: " + e.getMessage(), e);
        }
    }

    public abstract void setNonNullParameter(PreparedStatement var1, int var2, T var3, Integer var4) throws SQLException;

    public abstract T getNullableResult(ResultSet var1, String var2) throws SQLException;

    public abstract T getNullableResult(ResultSet var1, int var2) throws SQLException;

    public abstract T getNullableResult(CallableStatement var1, int var2) throws SQLException;
}

