/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.mapping.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.function.Property;
import net.hasor.db.mapping.Column;
import net.hasor.db.mapping.Ignore;
import net.hasor.db.mapping.Table;
import net.hasor.db.mapping.def.ColumnDef;
import net.hasor.db.mapping.def.TableDef;
import net.hasor.db.mapping.resolve.MappingOptions;
import net.hasor.db.mapping.resolve.TableMappingResolve;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;

public class ClassTableMappingResolve
implements TableMappingResolve<Class<?>> {
    private static final Map<Class<?>, Class<?>> CLASS_MAPPING_MAP = new HashMap();

    public static TableDef<?> resolveTableMapping(Class<?> entityType, ClassLoader classLoader, TypeHandlerRegistry typeRegistry) {
        return new ClassTableMappingResolve().resolveTableMapping(entityType, classLoader, typeRegistry, (MappingOptions)null);
    }

    @Override
    public TableDef<?> resolveTableMapping(Class<?> entityType, ClassLoader classLoader, TypeHandlerRegistry typeRegistry, MappingOptions options) {
        options = new MappingOptions(options);
        TableDef<?> def = this.resolveTable(entityType, options, typeRegistry);
        Map properties = BeanUtils.getPropertyFunc(entityType);
        ArrayList<String> names = new ArrayList<String>();
        List fields = BeanUtils.getALLFields(entityType).values().stream().map(Field::getName).collect(Collectors.toList());
        for (String name : fields) {
            if (!properties.containsKey(name)) continue;
            names.add(name);
        }
        for (String name : properties.keySet()) {
            if (names.contains(name)) continue;
            names.add(name);
        }
        for (String name : names) {
            Property property = (Property)properties.get(name);
            Class type = BeanUtils.getPropertyType((Property)property);
            this.resolveProperty(def, name, type, property, typeRegistry, options);
        }
        return def;
    }

    protected TableDef<?> resolveTable(Class<?> entityType, MappingOptions options, TypeHandlerRegistry typeRegistry) {
        if (entityType.isAnnotationPresent(Table.class)) {
            String table;
            Table defTable = entityType.getAnnotation(Table.class);
            String schema = defTable.schema();
            String string = StringUtils.isNotBlank((String)defTable.name()) ? defTable.name() : (table = StringUtils.isNotBlank((String)defTable.value()) ? defTable.value() : entityType.getSimpleName());
            if (defTable.mapUnderscoreToCamelCase() || Boolean.TRUE.equals(options.getMapUnderscoreToCamelCase())) {
                schema = this.hump2Line(schema, true);
                table = this.hump2Line(table, true);
                options.setMapUnderscoreToCamelCase(true);
            }
            boolean autoProperty = defTable.autoMapping();
            boolean useDelimited = defTable.useDelimited();
            boolean caseInsensitive = defTable.caseInsensitive() || options.getCaseInsensitive() == null || Boolean.TRUE.equals(options.getCaseInsensitive());
            return new TableDef(schema, table, entityType, autoProperty, useDelimited, caseInsensitive, typeRegistry);
        }
        String tableName = this.hump2Line(entityType.getSimpleName(), options.getMapUnderscoreToCamelCase());
        return new TableDef(null, tableName, entityType, true, false, true, typeRegistry);
    }

    private void resolveProperty(TableDef<?> tableDef, String name, Class<?> type, Property handler, TypeHandlerRegistry typeRegistry, MappingOptions options) {
        boolean primary;
        boolean update;
        boolean insert;
        TypeHandler<?> typeHandler;
        int jdbcType;
        Class<?> javaType;
        String column;
        Annotation[] annotations = BeanUtils.getPropertyAnnotation((Property)handler);
        Column info = null;
        for (Annotation a : annotations) {
            if (info == null && a instanceof Column) {
                info = (Column)a;
                continue;
            }
            if (!(a instanceof Ignore)) continue;
            return;
        }
        if (info != null) {
            String string = column = StringUtils.isNotBlank((String)info.name()) ? info.name() : info.value();
            if (StringUtils.isBlank((String)column)) {
                column = this.hump2Line(name, options.getMapUnderscoreToCamelCase());
            }
            javaType = info.specialJavaType() == Object.class ? CLASS_MAPPING_MAP.getOrDefault(type, type) : info.specialJavaType();
            jdbcType = info.jdbcType();
            if (info.jdbcType() == 2000) {
                jdbcType = TypeHandlerRegistry.toSqlType(javaType);
            }
            typeHandler = typeRegistry.getTypeHandler(javaType, jdbcType);
            insert = info.insert();
            update = info.update();
            primary = info.primary();
        } else if (tableDef.isAutoProperty()) {
            column = this.hump2Line(name, options.getMapUnderscoreToCamelCase());
            javaType = CLASS_MAPPING_MAP.getOrDefault(type, type);
            jdbcType = TypeHandlerRegistry.toSqlType(javaType);
            typeHandler = typeRegistry.getTypeHandler(javaType, jdbcType);
            insert = true;
            update = true;
            primary = false;
        } else {
            return;
        }
        tableDef.addMapping(new ColumnDef(column, name, jdbcType, javaType, typeHandler, handler, insert, update, primary));
    }

    private String hump2Line(String str, Boolean mapUnderscoreToCamelCase) {
        if (StringUtils.isBlank((String)str) || mapUnderscoreToCamelCase == null || !mapUnderscoreToCamelCase.booleanValue()) {
            return str;
        }
        return StringUtils.humpToLine((String)str);
    }

    static {
        CLASS_MAPPING_MAP.put(Collection.class, ArrayList.class);
        CLASS_MAPPING_MAP.put(List.class, ArrayList.class);
        CLASS_MAPPING_MAP.put(Set.class, LinkedHashSet.class);
        CLASS_MAPPING_MAP.put(Map.class, LinkedHashMap.class);
    }
}

