/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.hasor.db.dialect.BatchBoundSql;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.InsertSqlDialect;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.lambda.DuplicateKeyStrategy;
import net.hasor.db.lambda.LambdaTemplate;
import net.hasor.db.lambda.core.BasicLambda;
import net.hasor.db.lambda.core.InsertExecute;
import net.hasor.db.mapping.def.ColumnMapping;
import net.hasor.db.mapping.def.TableMapping;

public abstract class AbstractInsertLambda<R, T, P>
extends BasicLambda<R, T, P>
implements InsertExecute<R, T> {
    protected final List<ColumnMapping> insertProperties = this.getInsertProperties();
    protected final List<ColumnMapping> primaryKeyProperties = this.getPrimaryKeyColumns();
    protected final List<Object[]> insertValues = new ArrayList<Object[]>();
    protected DuplicateKeyStrategy insertStrategy = DuplicateKeyStrategy.Into;
    protected final List<String> primaryKeys = this.primaryKeyProperties.parallelStream().map(ColumnMapping::getColumn).collect(Collectors.toList());
    protected final List<String> insertColumns = this.insertProperties.parallelStream().map(ColumnMapping::getColumn).collect(Collectors.toList());

    public AbstractInsertLambda(Class<?> exampleType, TableMapping<?> tableMapping, LambdaTemplate jdbcTemplate) {
        super(exampleType, tableMapping, jdbcTemplate);
    }

    protected List<ColumnMapping> getInsertProperties() {
        TableMapping<?> tableMapping = this.getTableMapping();
        ArrayList<ColumnMapping> toInsertProperties = new ArrayList<ColumnMapping>();
        HashSet<String> insertColumns = new HashSet<String>();
        for (ColumnMapping mapping : tableMapping.getProperties()) {
            String columnName = mapping.getColumn();
            if (!mapping.isInsert()) continue;
            if (insertColumns.contains(columnName)) {
                throw new IllegalStateException("Multiple property mapping to '" + columnName + "' column");
            }
            insertColumns.add(columnName);
            toInsertProperties.add(mapping);
        }
        if (toInsertProperties.size() == 0) {
            throw new IllegalStateException("no column require INSERT.");
        }
        return toInsertProperties;
    }

    protected List<ColumnMapping> getPrimaryKeyColumns() {
        TableMapping<?> tableMapping = this.getTableMapping();
        ArrayList<ColumnMapping> pkProperties = new ArrayList<ColumnMapping>();
        HashSet<String> pkColumns = new HashSet<String>();
        for (ColumnMapping mapping : tableMapping.getProperties()) {
            String columnName = mapping.getColumn();
            if (!mapping.isPrimaryKey()) continue;
            if (pkColumns.contains(columnName)) {
                throw new IllegalStateException("Multiple property mapping to '" + columnName + "' column");
            }
            pkColumns.add(columnName);
            pkProperties.add(mapping);
        }
        return pkProperties;
    }

    @Override
    public R onDuplicateStrategy(DuplicateKeyStrategy insertStrategy) {
        this.insertStrategy = Objects.requireNonNull(insertStrategy);
        return this.getSelf();
    }

    @Override
    public R applyEntity(List<T> entityList) {
        int propertyCount = this.insertProperties.size();
        entityList.parallelStream().map(entity -> {
            Object[] args = new Object[propertyCount];
            for (int i = 0; i < propertyCount; ++i) {
                ColumnMapping mapping = this.insertProperties.get(i);
                args[i] = this.exampleIsMap() ? ((Map)entity).get(mapping.getProperty()) : mapping.getHandler().get(entity);
            }
            return args;
        }).forEach(this.insertValues::add);
        return this.getSelf();
    }

    @Override
    public R applyMap(List<Map<String, Object>> entityList) {
        int propertyCount = this.insertProperties.size();
        entityList.parallelStream().map(entity -> {
            Object[] args = new Object[propertyCount];
            for (int i = 0; i < propertyCount; ++i) {
                ColumnMapping mapping = this.insertProperties.get(i);
                args[i] = entity.get(mapping.getProperty());
            }
            return args;
        }).forEach(this.insertValues::add);
        return this.getSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeGetResult() throws SQLException {
        try {
            BoundSql boundSql = this.getBoundSql();
            String sqlString = boundSql.getSqlString();
            if (boundSql instanceof BatchBoundSql) {
                if (boundSql.getArgs().length > 1) {
                    int[] nArray = this.getJdbcTemplate().executeBatch(sqlString, ((BatchBoundSql)boundSql).getArgs());
                    return nArray;
                }
                int i = this.getJdbcTemplate().executeUpdate(sqlString, (Object[])boundSql.getArgs()[0]);
                int[] nArray = new int[]{i};
                return nArray;
            }
            int i = this.getJdbcTemplate().executeUpdate(sqlString, boundSql.getArgs());
            int[] nArray = new int[]{i};
            return nArray;
        }
        finally {
            this.insertValues.clear();
        }
    }

    @Override
    protected BoundSql buildBoundSql(SqlDialect dialect) {
        if (this.insertValues.size() == 0) {
            throw new IllegalStateException("there is no data to insert");
        }
        return this.dialectInsert(dialect);
    }

    protected BoundSql dialectInsert(SqlDialect dialect) {
        boolean isInsertSqlDialect = dialect instanceof InsertSqlDialect;
        TableMapping<?> tableMapping = this.getTableMapping();
        String schemaName = tableMapping.getSchema();
        String tableName = tableMapping.getTable();
        if (!isInsertSqlDialect) {
            String sqlString = this.defaultDialectInsert(this.isQualifier(), schemaName, tableName, this.insertColumns, dialect);
            return this.buildBatchBoundSql(sqlString);
        }
        switch (this.insertStrategy) {
            case Into: {
                InsertSqlDialect insertDialect = (InsertSqlDialect)dialect;
                if (!insertDialect.supportInsertInto(this.primaryKeys, this.insertColumns)) break;
                String sqlString = insertDialect.insertWithInto(this.isQualifier(), schemaName, tableName, this.primaryKeys, this.insertColumns);
                return this.buildBatchBoundSql(sqlString);
            }
            case Ignore: {
                InsertSqlDialect insertDialect = (InsertSqlDialect)dialect;
                if (!insertDialect.supportInsertIgnore(this.primaryKeys, this.insertColumns)) break;
                String sqlString = insertDialect.insertWithIgnore(this.isQualifier(), schemaName, tableName, this.primaryKeys, this.insertColumns);
                return this.buildBatchBoundSql(sqlString);
            }
            case Update: {
                InsertSqlDialect insertDialect = (InsertSqlDialect)dialect;
                if (!insertDialect.supportUpsert(this.primaryKeys, this.insertColumns)) break;
                String sqlString = insertDialect.insertWithUpsert(this.isQualifier(), schemaName, tableName, this.primaryKeys, this.insertColumns);
                return this.buildBatchBoundSql(sqlString);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)this.insertStrategy) + " Unsupported.");
    }

    protected BatchBoundSql buildBatchBoundSql(String batchSql) {
        Object[][] args = new Object[this.insertValues.size()][];
        for (int i = 0; i < this.insertValues.size(); ++i) {
            args[i] = this.insertValues.get(i);
        }
        return new BatchBoundSql.BatchBoundSqlObj(batchSql, args);
    }

    protected String defaultDialectInsert(boolean useQualifier, String schema, String table, List<String> columns, SqlDialect dialect) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("INSERT INTO ");
        strBuilder.append(dialect.tableName(useQualifier, schema, table));
        strBuilder.append(" ");
        strBuilder.append("(");
        StringBuilder argBuilder = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                strBuilder.append(", ");
                argBuilder.append(", ");
            }
            strBuilder.append(dialect.columnName(useQualifier, schema, table, columns.get(i)));
            argBuilder.append("?");
        }
        strBuilder.append(") VALUES (");
        strBuilder.append((CharSequence)argBuilder);
        strBuilder.append(")");
        return strBuilder.toString();
    }
}

