/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.hasor.db.jdbc.mapper.AbstractRowMapper;
import net.hasor.db.types.TypeHandlerRegistry;

public class SingleColumnRowMapper<T>
extends AbstractRowMapper<T> {
    private final Class<T> requiredType;

    public SingleColumnRowMapper(Class<T> requiredType) {
        this(requiredType, TypeHandlerRegistry.DEFAULT);
    }

    public SingleColumnRowMapper(Class<T> requiredType, TypeHandlerRegistry typeHandler) {
        super(typeHandler);
        this.requiredType = requiredType;
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        if (nrOfColumns != 1) {
            throw new SQLException("Incorrect column count: expected 1, actual " + nrOfColumns);
        }
        return (T)this.getResultSetValue(rs, 1, this.requiredType);
    }
}

