/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.InsertSqlDialect;
import net.hasor.db.dialect.PageSqlDialect;
import net.hasor.db.dialect.provider.AbstractDialect;

public class OracleDialect
extends AbstractDialect
implements PageSqlDialect,
InsertSqlDialect {
    @Override
    protected String keyWordsResource() {
        return "/META-INF/db-keywords/oracle.keywords";
    }

    @Override
    protected String defaultQualifier() {
        return "\"";
    }

    @Override
    public BoundSql countSql(BoundSql boundSql) {
        String sqlBuilder = "SELECT COUNT(*) FROM (" + boundSql.getSqlString() + ") TEMP_T";
        return new BoundSql.BoundSqlObj(sqlBuilder, boundSql.getArgs());
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, int start, int limit) {
        String sqlString = boundSql.getSqlString();
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT * FROM ( SELECT TMP.*, ROWNUM ROW_ID FROM ( ");
        sqlBuilder.append(sqlString);
        sqlBuilder.append(" ) TMP WHERE ROWNUM <= ? ) WHERE ROW_ID > ?");
        paramArrays.add(start + limit);
        paramArrays.add(start);
        return new BoundSql.BoundSqlObj(sqlBuilder.toString(), paramArrays.toArray());
    }

    @Override
    public boolean supportInsertInto(List<String> primaryKey, List<String> columns) {
        return true;
    }

    @Override
    public String insertWithInto(boolean useQualifier, String schema, String table, List<String> primaryKey, List<String> columns) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("INSERT INTO ");
        strBuilder.append(this.tableName(useQualifier, schema, table));
        strBuilder.append(" (");
        StringBuilder argBuilder = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                strBuilder.append(", ");
                argBuilder.append(", ");
            }
            strBuilder.append(this.columnName(useQualifier, schema, table, columns.get(i)));
            argBuilder.append("?");
        }
        strBuilder.append(") VALUES (");
        strBuilder.append((CharSequence)argBuilder);
        strBuilder.append(")");
        return strBuilder.toString();
    }

    @Override
    public boolean supportInsertIgnore(List<String> primaryKey, List<String> columns) {
        return !primaryKey.isEmpty();
    }

    @Override
    public String insertWithIgnore(boolean useQualifier, String schema, String table, List<String> primaryKey, List<String> columns) {
        StringBuilder mergeBuilder = new StringBuilder();
        this.buildMergeInfoBasic(useQualifier, schema, table, primaryKey, columns, mergeBuilder);
        this.buildMergeInfoWhenNotMatched(useQualifier, schema, table, columns, mergeBuilder);
        return mergeBuilder.toString();
    }

    @Override
    public boolean supportUpsert(List<String> primaryKey, List<String> columns) {
        return !primaryKey.isEmpty();
    }

    @Override
    public String insertWithUpsert(boolean useQualifier, String schema, String table, List<String> primaryKey, List<String> columns) {
        StringBuilder mergeBuilder = new StringBuilder();
        this.buildMergeInfoBasic(useQualifier, schema, table, primaryKey, columns, mergeBuilder);
        this.buildMergeInfoWhenMatched(useQualifier, schema, table, columns, mergeBuilder);
        this.buildMergeInfoWhenNotMatched(useQualifier, schema, table, columns, mergeBuilder);
        return mergeBuilder.toString();
    }

    private void buildMergeInfoBasic(boolean useQualifier, String schema, String table, List<String> primaryKey, List<String> columns, StringBuilder mergeBuilder) {
        int i;
        mergeBuilder.append("MERGE INTO ");
        mergeBuilder.append(this.tableName(useQualifier, schema, table));
        mergeBuilder.append(" TMP USING (SELECT ");
        for (i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                mergeBuilder.append(", ");
            }
            mergeBuilder.append("? ");
            mergeBuilder.append(this.columnName(useQualifier, schema, table, columns.get(i)));
        }
        mergeBuilder.append(" FROM dual ) SRC ON (");
        for (i = 0; i < primaryKey.size(); ++i) {
            if (i != 0) {
                mergeBuilder.append(" AND ");
            }
            String pkColumn = this.columnName(useQualifier, schema, table, primaryKey.get(i));
            mergeBuilder.append("TMP." + pkColumn + " = SRC." + pkColumn);
        }
        mergeBuilder.append(") ");
    }

    private void buildMergeInfoWhenNotMatched(boolean useQualifier, String schema, String table, List<String> allColumns, StringBuilder mergeBuilder) {
        mergeBuilder.append("WHEN NOT MATCHED THEN ");
        mergeBuilder.append("INSERT (");
        StringBuilder argBuilder = new StringBuilder();
        for (int i = 0; i < allColumns.size(); ++i) {
            if (i > 0) {
                mergeBuilder.append(", ");
                argBuilder.append(", ");
            }
            mergeBuilder.append(this.columnName(useQualifier, schema, table, allColumns.get(i)));
            argBuilder.append("SRC.").append(this.columnName(useQualifier, schema, table, allColumns.get(i)));
        }
        mergeBuilder.append(") VALUES( ");
        mergeBuilder.append((CharSequence)argBuilder);
        mergeBuilder.append(") ");
    }

    private void buildMergeInfoWhenMatched(boolean useQualifier, String schema, String table, List<String> allColumns, StringBuilder mergeBuilder) {
        mergeBuilder.append("WHEN MATCHED THEN ");
        mergeBuilder.append("UPDATE SET ");
        for (int i = 0; i < allColumns.size(); ++i) {
            String column = allColumns.get(i);
            if (i != 0) {
                mergeBuilder.append(", ");
            }
            mergeBuilder.append(this.columnName(useQualifier, schema, table, column));
            mergeBuilder.append(" = SRC.");
            mergeBuilder.append(this.columnName(useQualifier, schema, table, column));
        }
        mergeBuilder.append(" ");
    }
}

