/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect.provider;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.hasor.cobble.ResourcesUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.io.IOUtils;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.db.dialect.ConditionSqlDialect;
import net.hasor.db.dialect.SqlDialect;

public abstract class AbstractDialect
implements SqlDialect,
ConditionSqlDialect {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDialect.class);
    private Set<String> keyWords;

    @Override
    public final Set<String> keywords() {
        if (this.keyWords == null) {
            this.keyWords = new HashSet<String>();
            String keyWordsResource = this.keyWordsResource();
            if (StringUtils.isBlank((String)keyWordsResource)) {
                return this.keyWords;
            }
            try {
                List strings = IOUtils.readLines((InputStream)ResourcesUtils.getResourceAsStream((String)keyWordsResource), (Charset)StandardCharsets.UTF_8);
                for (String term : strings) {
                    if (StringUtils.isBlank((String)(term = term.trim().toUpperCase())) || term.charAt(0) == '#') continue;
                    this.keyWords.add(term);
                }
            }
            catch (Exception e) {
                logger.error("load " + this.keywords() + ".keywords failed." + e.getMessage(), (Throwable)e);
            }
        }
        return this.keyWords;
    }

    protected String keyWordsResource() {
        return null;
    }

    @Override
    public String tableName(boolean useQualifier, String schema, String table) {
        if (StringUtils.isBlank((String)schema)) {
            return this.fmtName(useQualifier, table);
        }
        return this.fmtName(useQualifier, schema) + "." + this.fmtName(useQualifier, table);
    }

    @Override
    public String columnName(boolean useQualifier, String schema, String table, String column) {
        return this.fmtName(useQualifier, column);
    }

    protected String fmtName(boolean useQualifier, String fmtString) {
        if (this.keywords().contains(fmtString.toUpperCase())) {
            useQualifier = true;
        }
        String leftQualifier = useQualifier ? this.leftQualifier() : "";
        String rightQualifier = useQualifier ? this.rightQualifier() : "";
        return leftQualifier + fmtString + rightQualifier;
    }

    protected String defaultQualifier() {
        return "";
    }

    @Override
    public String leftQualifier() {
        return this.defaultQualifier();
    }

    @Override
    public String rightQualifier() {
        return this.defaultQualifier();
    }
}

