/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.session;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.hasor.db.dal.session.BaseMapper;
import net.hasor.db.dal.session.DalSession;
import net.hasor.db.lambda.EntityDeleteOperation;
import net.hasor.db.lambda.EntityQueryOperation;
import net.hasor.db.lambda.EntityUpdateOperation;
import net.hasor.db.lambda.InsertOperation;
import net.hasor.db.lambda.LambdaTemplate;
import net.hasor.db.mapping.def.ColumnMapping;
import net.hasor.db.mapping.def.TableMapping;
import net.hasor.db.page.Page;
import net.hasor.db.page.PageObject;
import net.hasor.db.page.PageResult;

class BaseMapperHandler
implements BaseMapper<Object> {
    private final String space;
    private final Class<Object> entityType;
    private final DalSession dalSession;
    private final TableMapping<Object> tableMapping;

    public BaseMapperHandler(String space, Class<?> entityType, DalSession dalSession) {
        this.space = space;
        this.entityType = entityType;
        this.dalSession = dalSession;
        TableMapping tableMapping = dalSession.getDalRegistry().findTableMapping(space, this.entityType);
        if (tableMapping == null) {
            throw new IllegalStateException("entityType '" + entityType.getName() + "' tableMapping is null.");
        }
        this.tableMapping = tableMapping;
    }

    @Override
    public Class<Object> entityType() {
        return this.entityType;
    }

    @Override
    public LambdaTemplate template() {
        return this.dalSession.newTemplate(this.space);
    }

    @Override
    public DalSession getSession() {
        return this.dalSession;
    }

    private TableMapping<Object> getMapping() {
        return this.tableMapping;
    }

    protected List<ColumnMapping> foundPrimaryKey() {
        TableMapping<Object> tableMapping = this.getMapping();
        return tableMapping.getProperties().stream().filter(ColumnMapping::isPrimaryKey).collect(Collectors.toList());
    }

    @Override
    public int saveOrUpdate(Object entity) throws SQLException {
        if (entity == null) {
            throw new NullPointerException("entity is null.");
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new SQLException(this.entityType() + " no primary key is identified");
        }
        EntityQueryOperation query = this.query();
        EntityUpdateOperation<Object> update = this.update();
        for (ColumnMapping pk : pks) {
            Object o = pk.getHandler().get(entity);
            if (o == null) {
                ((EntityQueryOperation)query.and()).isNull(pk.getColumn());
                ((EntityUpdateOperation)update.and()).isNull(pk.getColumn());
                continue;
            }
            ((EntityQueryOperation)query.and()).eq(pk.getColumn(), o);
            ((EntityUpdateOperation)update.and()).eq(pk.getColumn(), o);
        }
        if (query.queryForCount() == 0) {
            return ((InsertOperation)this.insert().applyEntity(entity)).executeSumResult();
        }
        return ((EntityUpdateOperation)update.updateTo(entity)).doUpdate();
    }

    @Override
    public int delete(Object entity) throws SQLException {
        if (entity == null) {
            throw new NullPointerException("entity is null.");
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new SQLException(this.entityType() + " no primary key is identified");
        }
        EntityDeleteOperation delete = this.delete();
        for (ColumnMapping pk : pks) {
            Object o = pk.getHandler().get(entity);
            if (o == null) {
                ((EntityDeleteOperation)delete.and()).isNull(pk.getColumn());
                continue;
            }
            ((EntityDeleteOperation)delete.and()).eq(pk.getColumn(), o);
        }
        return delete.doDelete();
    }

    @Override
    public int deleteById(Serializable id) throws SQLException {
        if (id == null) {
            return 0;
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new SQLException(this.entityType() + " no primary key is identified");
        }
        EntityDeleteOperation delete = this.delete();
        if (pks.size() == 1) {
            ((EntityDeleteOperation)delete.and()).eq(pks.get(0).getColumn(), (Object)id);
        } else {
            for (ColumnMapping pk : pks) {
                Object o = pk.getHandler().get((Object)id);
                if (o == null) {
                    ((EntityDeleteOperation)delete.and()).isNull(pk.getColumn());
                    continue;
                }
                ((EntityDeleteOperation)delete.and()).eq(pk.getColumn(), o);
            }
        }
        return delete.doDelete();
    }

    @Override
    public int deleteByIds(List<? extends Serializable> idList) throws SQLException {
        if (idList == null || idList.isEmpty()) {
            return 0;
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new SQLException(this.entityType() + " no primary key is identified");
        }
        if (pks.size() == 1) {
            EntityDeleteOperation delete = this.delete();
            return ((EntityDeleteOperation)((EntityDeleteOperation)delete.and()).in(pks.get(0).getColumn(), (Collection<?>)idList)).doDelete();
        }
        EntityDeleteOperation delete = this.delete();
        for (Serializable serializable : idList) {
            delete.or(queryCompare -> {
                for (ColumnMapping pkColumn : pks) {
                    Object keyValue = pkColumn.getHandler().get(obj);
                    if (keyValue == null) {
                        ((EntityDeleteOperation)queryCompare.and()).isNull(pkColumn.getColumn());
                        continue;
                    }
                    ((EntityDeleteOperation)queryCompare.and()).eq(pkColumn.getColumn(), keyValue);
                }
            });
        }
        return delete.doDelete();
    }

    @Override
    public Object getById(Serializable id) throws SQLException {
        if (id == null) {
            return null;
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new SQLException(this.entityType() + " no primary key is identified");
        }
        EntityQueryOperation query = this.query();
        if (pks.size() == 1) {
            ((EntityQueryOperation)query.and()).eq(pks.get(0).getColumn(), (Object)id);
        } else {
            for (ColumnMapping pk : pks) {
                Object o = pk.getHandler().get((Object)id);
                if (o == null) {
                    ((EntityQueryOperation)query.and()).isNull(pk.getColumn());
                    continue;
                }
                ((EntityQueryOperation)query.and()).eq(pk.getColumn(), o);
            }
        }
        return query.queryForObject();
    }

    @Override
    public List<Object> getByIds(List<? extends Serializable> idList) throws SQLException {
        if (idList == null || idList.isEmpty()) {
            return Collections.emptyList();
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new SQLException(this.entityType() + " no primary key is identified");
        }
        if (pks.size() == 1) {
            return ((EntityQueryOperation)((EntityQueryOperation)this.query().and()).in(pks.get(0).getColumn(), (Collection<?>)idList)).queryForList();
        }
        EntityQueryOperation query = this.query();
        for (Serializable serializable : idList) {
            query.or(queryCompare -> {
                for (ColumnMapping pkColumn : pks) {
                    Object keyValue = pkColumn.getHandler().get(obj);
                    if (keyValue == null) {
                        ((EntityQueryOperation)queryCompare.and()).isNull(pkColumn.getColumn());
                        continue;
                    }
                    ((EntityQueryOperation)queryCompare.and()).eq(pkColumn.getColumn(), keyValue);
                }
            });
        }
        return query.queryForList();
    }

    protected EntityQueryOperation<Object> buildQueryBySample(Object sample) {
        EntityQueryOperation<Object> query = this.query();
        if (sample != null) {
            for (ColumnMapping mapping : this.getMapping().getProperties()) {
                Object value = mapping.getHandler().get(sample);
                if (value == null) continue;
                ((EntityQueryOperation)query.and()).eq(mapping.getColumn(), value);
            }
        }
        return query;
    }

    @Override
    public List<Object> listBySample(Object sample) throws SQLException {
        return this.buildQueryBySample(sample).queryForList();
    }

    @Override
    public int countBySample(Object sample) throws SQLException {
        return this.buildQueryBySample(sample).queryForCount();
    }

    @Override
    public int countAll() throws SQLException {
        return this.query().queryForCount();
    }

    @Override
    public PageResult<Object> pageBySample(Object sample, Page page) throws SQLException {
        List result = ((EntityQueryOperation)this.buildQueryBySample(sample).usePage(page)).queryForList();
        return new PageResult<Object>(page, page.getTotalCount(), result);
    }

    @Override
    public Page initPageBySample(Object sample, int pageSize, int pageNumberOffset) throws SQLException {
        int totalCount = this.countBySample(sample);
        PageObject pageObject = new PageObject(pageSize, totalCount);
        pageObject.setPageNumberOffset(pageNumberOffset);
        return pageObject;
    }
}

