/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.execute;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.db.dal.dynamic.DynamicContext;
import net.hasor.db.dal.dynamic.SqlArg;
import net.hasor.db.dal.execute.AbstractStatementExecute;
import net.hasor.db.dal.execute.DalResultSetExtractor;
import net.hasor.db.dal.repository.ResultSetType;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.PageSqlDialect;
import net.hasor.db.dialect.SqlBuilder;
import net.hasor.db.page.PageResult;
import net.hasor.db.types.TypeHandler;

public class PreparedStatementExecute
extends AbstractStatementExecute<Object> {
    public PreparedStatementExecute(DynamicContext context) {
        super(context);
    }

    protected PreparedStatement createPreparedStatement(Connection conn, String queryString, ResultSetType resultSetType) throws SQLException {
        if (resultSetType == null || resultSetType.getResultSetType() == null) {
            return conn.prepareStatement(queryString);
        }
        int resultSetTypeInt = resultSetType.getResultSetType();
        return conn.prepareStatement(queryString, resultSetTypeInt, 1007);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object executeQuery(Connection con, AbstractStatementExecute.ExecuteInfo executeInfo, SqlBuilder sqlBuilder) throws SQLException {
        BoundSql boundSql = sqlBuilder;
        BoundSql countSql = null;
        if (this.usingPage(executeInfo)) {
            PageSqlDialect dialect = executeInfo.pageDialect;
            int position = executeInfo.pageInfo.getFirstRecordPosition();
            int pageSize222 = executeInfo.pageInfo.getPageSize();
            boundSql = dialect.pageSql(sqlBuilder, position, pageSize222);
            if (executeInfo.pageResult) {
                countSql = dialect.countSql(sqlBuilder);
            }
        }
        Object resultData = null;
        try (PreparedStatement ps = this.createPreparedStatement(con, boundSql.getSqlString(), executeInfo.resultSetType);){
            this.configStatement(executeInfo, ps);
            resultData = this.executeQuery(ps, executeInfo, boundSql);
            if (countSql == null) {
                Object object = resultData;
                return object;
            }
        }
        catch (SQLException e) {
            logger.error("executeQuery failed, " + ExceptionUtils.getRootCauseMessage((Throwable)e) + ", " + PreparedStatementExecute.fmtBoundSql(boundSql, executeInfo.data), (Throwable)e);
            throw e;
        }
        int resultCount = 0;
        try (PreparedStatement ps = this.createPreparedStatement(con, countSql.getSqlString(), executeInfo.resultSetType);){
            this.configStatement(executeInfo, ps);
            resultCount = this.executeCount(ps, countSql);
        }
        catch (SQLException e) {
            logger.error("executeCount failed, " + ExceptionUtils.getRootCauseMessage((Throwable)e) + ", " + PreparedStatementExecute.fmtBoundSql(countSql, executeInfo.data), (Throwable)e);
            throw e;
        }
        PageResult<Object> pageResult = new PageResult<Object>(executeInfo.pageInfo, resultCount);
        pageResult.setData(resultData instanceof List ? (List<Object>)resultData : Collections.singletonList(resultData));
        return pageResult;
    }

    protected void statementSet(PreparedStatement ps, BoundSql boundSql) throws SQLException {
        List<SqlArg> sqlArgs = this.toArgs(boundSql);
        for (int i = 0; i < sqlArgs.size(); ++i) {
            SqlArg arg = sqlArgs.get(i);
            TypeHandler<?> typeHandler = arg.getTypeHandler();
            typeHandler.setParameter(ps, i + 1, arg.getValue(), arg.getJdbcType());
        }
    }

    protected Object executeQuery(PreparedStatement ps, AbstractStatementExecute.ExecuteInfo executeInfo, BoundSql boundSql) throws SQLException {
        this.statementSet(ps, boundSql);
        DalResultSetExtractor extractor = super.buildExtractor(executeInfo);
        boolean retVal = ps.execute();
        List<Object> result = extractor.doResult(retVal, ps);
        return this.getResult(result, executeInfo);
    }

    protected int executeCount(PreparedStatement ps, BoundSql boundSql) throws SQLException {
        this.statementSet(ps, boundSql);
        try (ResultSet resultSet = ps.executeQuery();){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            int n = -1;
            return n;
        }
    }
}

