/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.dynamic.segment;

import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.db.dal.dynamic.DynamicSql;
import net.hasor.db.dal.dynamic.rule.ArgRule;
import net.hasor.db.dal.dynamic.segment.DefaultSqlSegment;
import net.hasor.db.dal.dynamic.tokens.GenericTokenParser;

public class SqlSegmentParser {
    public static DynamicSql analysisSQL(String fragmentString) {
        DefaultSqlSegment fxSql = new DefaultSqlSegment();
        String result = new GenericTokenParser(new String[]{"@{", "#{", "${"}, "}", (builder, token, content) -> {
            fxSql.appendString(builder.toString());
            if (token.equalsIgnoreCase("@{")) {
                SqlSegmentParser.parserRule(fxSql, content);
            }
            if (token.equalsIgnoreCase("${")) {
                SqlSegmentParser.parserPlaceholder(fxSql, content);
            }
            if (token.equalsIgnoreCase("#{")) {
                SqlSegmentParser.parserValue(fxSql, content);
            }
            builder.delete(0, builder.length());
            return "";
        }).parse(fragmentString);
        fxSql.appendString(result);
        return fxSql;
    }

    private static void parserPlaceholder(DefaultSqlSegment fxQuery, String content) {
        fxQuery.appendPlaceholderExpr(content);
    }

    public static void parserRule(DefaultSqlSegment fxQuery, String content) {
        int index = 0;
        int readIndex = 0;
        int length = content.length();
        String ruleName = null;
        String activeExpr = "true";
        String ruleContent = null;
        if (index < length) {
            readIndex = SqlSegmentParser.nextTokenIndex(index, content);
            ruleName = content.substring(index, readIndex);
            index = readIndex + 1;
        }
        if (index < length) {
            readIndex = SqlSegmentParser.nextTokenIndex(index, content);
            activeExpr = content.substring(index, readIndex);
            if (StringUtils.isBlank((String)activeExpr)) {
                activeExpr = "true";
            }
            index = readIndex + 1;
        }
        if (index < length) {
            ruleContent = content.substring(index);
        }
        if (StringUtils.isBlank(ruleName)) {
            throw new IllegalArgumentException("analysisSQL failed, rule name is null.");
        }
        fxQuery.appendRuleExpr(ruleName, activeExpr, ruleContent);
    }

    private static int nextTokenIndex(int start, String content) {
        int index;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        boolean inEscape = false;
        for (index = start; index < content.length(); ++index) {
            char c = content.charAt(index);
            if (inEscape) {
                inEscape = false;
                continue;
            }
            if ('\'' == c) {
                if (!inSingleQuotes && !inDoubleQuotes) {
                    inSingleQuotes = true;
                    continue;
                }
                if (!inSingleQuotes) continue;
                inSingleQuotes = false;
                continue;
            }
            if ('\"' == c) {
                if (!inDoubleQuotes && !inSingleQuotes) {
                    inDoubleQuotes = true;
                    continue;
                }
                if (!inDoubleQuotes) continue;
                inDoubleQuotes = false;
                continue;
            }
            if ('\\' == c) {
                if (!inDoubleQuotes && !inSingleQuotes) continue;
                inEscape = true;
                continue;
            }
            if (',' != c || inDoubleQuotes || inSingleQuotes) continue;
            return index;
        }
        return index;
    }

    private static void parserValue(DefaultSqlSegment fxQuery, String content) {
        String[] testSplit = content.split(",");
        if (testSplit.length > 6 || testSplit.length == 0) {
            throw new IllegalArgumentException("analysisSQL failed, format error -> '#{valueExpr [,mode= IN|OUT|INOUT] [,jdbcType=INT] [,javaType=java.lang.String] [,typeHandler=YouTypeHandlerClassName]}'");
        }
        boolean noExpr = StringUtils.contains((String)testSplit[0], (String)"=");
        String expr = noExpr ? "" : testSplit[0];
        Map<String, String> config = ArgRule.INSTANCE.parserConfig(testSplit, noExpr ? 0 : 1, testSplit.length);
        fxQuery.appendValueExpr(expr, config);
    }
}

