/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.dynamic.nodes;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.db.dal.dynamic.DynamicContext;
import net.hasor.db.dal.dynamic.nodes.ArrayDynamicSql;
import net.hasor.db.dal.dynamic.ognl.OgnlUtils;
import net.hasor.db.dialect.SqlBuilder;

public class ForeachDynamicSql
extends ArrayDynamicSql {
    private final String collection;
    private final String item;
    private final String open;
    private final String close;
    private final String separator;

    public ForeachDynamicSql(String collection, String item, String open, String close, String separator) {
        this.collection = collection;
        this.item = item;
        this.open = open;
        this.close = close;
        this.separator = separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildQuery(Map<String, Object> data, DynamicContext context, SqlBuilder sqlBuilder) throws SQLException {
        Object[] collectionData = OgnlUtils.evalOgnl(this.collection, data);
        if (collectionData == null) {
            return;
        }
        if (collectionData instanceof Collection) {
            collectionData = ((Collection)collectionData).toArray();
        }
        if (!collectionData.getClass().isArray()) {
            collectionData = new Object[]{collectionData};
        }
        sqlBuilder.appendSql(StringUtils.defaultString((String)this.open));
        Object oriValue = data.get(this.item);
        try {
            int length = Array.getLength(collectionData);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    sqlBuilder.appendSql(StringUtils.defaultString((String)this.separator));
                }
                data.put(this.item, Array.get(collectionData, i));
                super.buildQuery(data, context, sqlBuilder);
            }
            sqlBuilder.appendSql(StringUtils.defaultString((String)this.close));
        }
        finally {
            data.put(this.item, oriValue);
        }
    }
}

