/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Year;
import net.hasor.cobble.StringUtils;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class YearOfStringTypeHandler
extends AbstractTypeHandler<Year> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Year year, Integer jdbcType) throws SQLException {
        ps.setString(i, String.valueOf(year.getValue()));
    }

    @Override
    public Year getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String year = rs.getString(columnName);
        return StringUtils.isBlank((String)year) ? null : Year.parse(year);
    }

    @Override
    public Year getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String year = rs.getString(columnIndex);
        return StringUtils.isBlank((String)year) ? null : Year.parse(year);
    }

    @Override
    public Year getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String year = cs.getString(columnIndex);
        return StringUtils.isBlank((String)year) ? null : Year.parse(year);
    }
}

