/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import net.hasor.cobble.io.IOUtils;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class SqlXmlForInputStreamTypeHandler
extends AbstractTypeHandler<InputStream> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, InputStream parameter, Integer jdbcType) throws SQLException {
        SQLXML sqlxml = ps.getConnection().createSQLXML();
        try {
            OutputStream writer = sqlxml.setBinaryStream();
            IOUtils.copy((InputStream)parameter, (OutputStream)writer);
            ps.setSQLXML(i, sqlxml);
        }
        catch (IOException e) {
            throw new SQLException("Error copy xml data to SQLXML for parameter #" + i + " with JdbcType " + jdbcType + ", Cause: " + e.getMessage(), e);
        }
        finally {
            sqlxml.free();
        }
    }

    @Override
    public InputStream getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.sqlXmlToStream(rs.getSQLXML(columnName));
    }

    @Override
    public InputStream getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.sqlXmlToStream(rs.getSQLXML(columnIndex));
    }

    @Override
    public InputStream getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.sqlXmlToStream(cs.getSQLXML(columnIndex));
    }

    protected InputStream sqlXmlToStream(SQLXML sqlxml) throws SQLException {
        if (sqlxml == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream binaryStream = sqlxml.getBinaryStream();){
            IOUtils.copy((InputStream)binaryStream, (OutputStream)baos);
        }
        catch (IOException e) {
            throw new SQLException("read binary Xml Data failed : " + e.getMessage(), e);
        }
        finally {
            sqlxml.free();
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

