/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import net.hasor.cobble.ResourcesUtils;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;
import net.hasor.db.types.handler.AbstractTypeHandler;
import net.hasor.db.types.handler.ObjectTypeHandler;

public class UnknownTypeHandler
extends AbstractTypeHandler<Object> {
    private static final ObjectTypeHandler OBJECT_TYPE_HANDLER = new ObjectTypeHandler();
    private final TypeHandlerRegistry typeHandlerRegistry;

    public UnknownTypeHandler(TypeHandlerRegistry typeHandlerRegistry) {
        this.typeHandlerRegistry = typeHandlerRegistry;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, Integer jdbcType) throws SQLException {
        TypeHandler<?> handler = this.resolveTypeHandler(parameter, jdbcType);
        handler.setParameter(ps, i, parameter, jdbcType);
    }

    @Override
    public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
        TypeHandler<?> handler = this.resolveTypeHandler(rs, columnName);
        return UnknownTypeHandler.tryFixHandler(handler).getResult(rs, columnName);
    }

    @Override
    public Object getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        TypeHandler<?> handler = this.resolveTypeHandler(rs.getMetaData(), (Integer)columnIndex);
        return UnknownTypeHandler.tryFixHandler(handler).getResult(rs, columnIndex);
    }

    @Override
    public Object getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        TypeHandler<?> handler = this.resolveTypeHandler(cs.getMetaData(), (Integer)columnIndex);
        return UnknownTypeHandler.tryFixHandler(handler).getResult(cs, columnIndex);
    }

    private static TypeHandler<?> tryFixHandler(TypeHandler<?> handler) {
        if (handler == null || handler instanceof UnknownTypeHandler) {
            handler = OBJECT_TYPE_HANDLER;
        }
        return handler;
    }

    private TypeHandler<?> resolveTypeHandler(Object parameter, Integer jdbcType) {
        TypeHandler<Object> handler = null;
        if (parameter == null) {
            handler = OBJECT_TYPE_HANDLER;
        } else {
            handler = this.typeHandlerRegistry.getTypeHandler(parameter.getClass(), jdbcType);
            if (handler == null || handler instanceof UnknownTypeHandler) {
                handler = OBJECT_TYPE_HANDLER;
            }
        }
        return handler;
    }

    private TypeHandler<?> resolveTypeHandler(ResultSet rs, String column) {
        try {
            HashMap<String, Integer> columnIndexLookup = new HashMap<String, Integer>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int count = rsmd.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                String name = rsmd.getColumnName(i);
                columnIndexLookup.put(name, i);
            }
            Integer columnIndex = (Integer)columnIndexLookup.get(column);
            TypeHandler<Object> handler = null;
            if (columnIndex != null) {
                handler = this.resolveTypeHandler(rsmd, columnIndex);
            }
            if (handler == null || handler instanceof UnknownTypeHandler) {
                handler = OBJECT_TYPE_HANDLER;
            }
            return handler;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error determining JDBC type for column " + column + ".  Cause: " + e, e);
        }
    }

    private TypeHandler<?> resolveTypeHandler(ResultSetMetaData rsmd, Integer columnIndex) {
        TypeHandler<?> handler = null;
        Integer jdbcType = UnknownTypeHandler.safeGetJdbcTypeForColumn(rsmd, columnIndex);
        Class<?> javaType = UnknownTypeHandler.safeGetClassForColumn(rsmd, columnIndex);
        if (javaType != null && jdbcType != null) {
            handler = this.typeHandlerRegistry.getTypeHandler(javaType, jdbcType);
        } else if (javaType != null) {
            handler = this.typeHandlerRegistry.getTypeHandler(javaType);
        } else if (jdbcType != null) {
            handler = this.typeHandlerRegistry.getTypeHandler(jdbcType);
        }
        return handler;
    }

    private static Integer safeGetJdbcTypeForColumn(ResultSetMetaData rsmd, Integer columnIndex) {
        try {
            return rsmd.getColumnType(columnIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> safeGetClassForColumn(ResultSetMetaData rsmd, Integer columnIndex) {
        try {
            return ResourcesUtils.classForName((String)rsmd.getColumnClassName(columnIndex));
        }
        catch (Exception e) {
            return null;
        }
    }
}

