/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction.support;

import java.sql.SQLException;
import javax.sql.DataSource;
import net.hasor.db.transaction.ConnectionHolder;
import net.hasor.db.transaction.Isolation;

public class TransactionObject {
    private final ConnectionHolder holder;
    private final DataSource dataSource;
    private final Isolation recoverIsolation;
    private boolean recoverMark = false;

    public TransactionObject(ConnectionHolder holder, Isolation recoverIsolation, DataSource dataSource) throws SQLException {
        this.holder = holder;
        this.dataSource = dataSource;
        this.recoverIsolation = recoverIsolation;
    }

    public Isolation getRecoverIsolation() {
        return this.recoverIsolation;
    }

    public ConnectionHolder getHolder() {
        return this.holder;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void rollback() throws SQLException {
        if (this.holder.hasTransaction()) {
            this.holder.getConnection().rollback();
        }
    }

    public void commit() throws SQLException {
        if (this.holder.hasTransaction()) {
            this.holder.getConnection().commit();
        }
    }

    public boolean hasTransaction() throws SQLException {
        return this.holder.hasTransaction();
    }

    public void beginTransaction() throws SQLException {
        if (!this.holder.hasTransaction()) {
            this.recoverMark = true;
        }
        this.holder.setTransaction();
    }

    public void stopTransaction() throws SQLException {
        if (!this.recoverMark) {
            return;
        }
        this.recoverMark = false;
        this.holder.cancelTransaction();
    }
}

