/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction.support;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;
import javax.sql.DataSource;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.db.transaction.ConnectionHolder;
import net.hasor.db.transaction.Isolation;
import net.hasor.db.transaction.Propagation;
import net.hasor.db.transaction.TransactionManager;
import net.hasor.db.transaction.TransactionStatus;
import net.hasor.db.transaction.support.LocalTransactionStatus;
import net.hasor.db.transaction.support.SyncManager;
import net.hasor.db.transaction.support.TransactionObject;

public class LocalTransactionManager
implements TransactionManager,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(LocalTransactionManager.class);
    private final Deque<LocalTransactionStatus> tStatusStack = new LinkedBlockingDeque<LocalTransactionStatus>();
    private final DataSource dataSource;

    public LocalTransactionManager(DataSource dataSource) {
        Objects.requireNonNull(dataSource);
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean hasTransaction() {
        return !this.tStatusStack.isEmpty();
    }

    @Override
    public boolean isTopTransaction(TransactionStatus status) {
        if (this.tStatusStack.isEmpty() || status == null) {
            return false;
        }
        return this.tStatusStack.peek() == status;
    }

    @Override
    public void commit() throws SQLException {
        LocalTransactionStatus last = this.tStatusStack.peek();
        if (last != null) {
            this.commit(last);
        }
    }

    @Override
    public void rollBack() throws SQLException {
        LocalTransactionStatus last = this.tStatusStack.peek();
        if (last != null) {
            this.rollBack(last);
        }
    }

    @Override
    public final TransactionStatus begin(Propagation behavior, Isolation level) throws SQLException {
        Objects.requireNonNull(behavior);
        LocalTransactionStatus defStatus = new LocalTransactionStatus(behavior, level);
        defStatus.setTranConn(this.doGetConnection(defStatus));
        this.tStatusStack.addFirst(defStatus);
        if (this.isExistingTransaction(defStatus)) {
            if (behavior == Propagation.REQUIRES_NEW) {
                this.suspend(defStatus);
                this.doBegin(defStatus);
            }
            if (behavior == Propagation.NESTED) {
                defStatus.markSavepoint();
            }
            if (behavior == Propagation.NOT_SUPPORTED) {
                this.suspend(defStatus);
            }
            if (behavior == Propagation.NEVER) {
                this.cleanupAfterCompletion(defStatus);
                throw new SQLException("existing transaction found for transaction marked with propagation 'never'");
            }
            return defStatus;
        }
        if (behavior == Propagation.REQUIRED || behavior == Propagation.REQUIRES_NEW || behavior == Propagation.NESTED) {
            this.doBegin(defStatus);
        }
        if (behavior == Propagation.MANDATORY) {
            this.cleanupAfterCompletion(defStatus);
            throw new SQLException("no existing transaction found for transaction marked with propagation 'mandatory'");
        }
        return defStatus;
    }

    private boolean isExistingTransaction(LocalTransactionStatus defStatus) throws SQLException {
        return defStatus.getTranConn().hasTransaction();
    }

    protected void doBegin(LocalTransactionStatus defStatus) throws SQLException {
        TransactionObject tranConn = defStatus.getTranConn();
        tranConn.beginTransaction();
    }

    @Override
    public final void commit(TransactionStatus status) throws SQLException {
        LocalTransactionStatus defStatus = (LocalTransactionStatus)status;
        if (defStatus.isCompleted()) {
            throw new SQLException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        if (defStatus.isReadOnly() || defStatus.isRollbackOnly()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Transactional code has requested rollback");
            }
            this.rollBack(defStatus);
            return;
        }
        try {
            this.prepareCommit(defStatus);
            if (defStatus.hasSavepoint()) {
                defStatus.releaseSavepoint();
            } else if (defStatus.isNewConnection()) {
                this.doCommit(defStatus);
            }
        }
        catch (SQLException ex) {
            this.doRollback(defStatus);
            throw ex;
        }
        finally {
            this.cleanupAfterCompletion(defStatus);
        }
    }

    private void prepareCommit(LocalTransactionStatus defStatus) throws SQLException {
        if (!this.tStatusStack.contains(defStatus)) {
            throw new SQLException("This transaction is not derived from this Manager.");
        }
        TransactionStatus inStackStatus = null;
        while ((inStackStatus = (TransactionStatus)this.tStatusStack.peek()) != defStatus) {
            this.commit(inStackStatus);
        }
    }

    protected void doCommit(LocalTransactionStatus defStatus) throws SQLException {
        TransactionObject tranObject = defStatus.getTranConn();
        tranObject.commit();
    }

    @Override
    public final void rollBack(TransactionStatus status) throws SQLException {
        LocalTransactionStatus defStatus = (LocalTransactionStatus)status;
        if (defStatus.isCompleted()) {
            throw new SQLException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        try {
            this.prepareRollback(defStatus);
            if (defStatus.hasSavepoint()) {
                defStatus.rollbackToSavepoint();
            } else if (defStatus.isNewConnection()) {
                this.doRollback(defStatus);
            }
        }
        catch (SQLException ex) {
            this.doRollback(defStatus);
            throw ex;
        }
        finally {
            this.cleanupAfterCompletion(defStatus);
        }
    }

    private void prepareRollback(LocalTransactionStatus defStatus) throws SQLException {
        if (!this.tStatusStack.contains(defStatus)) {
            throw new SQLException("This transaction is not derived from this Manager.");
        }
        TransactionStatus inStackStatus = null;
        while ((inStackStatus = (TransactionStatus)this.tStatusStack.peek()) != defStatus) {
            this.rollBack(inStackStatus);
        }
    }

    protected void doRollback(LocalTransactionStatus defStatus) throws SQLException {
        TransactionObject tranObject = defStatus.getTranConn();
        tranObject.rollback();
    }

    protected final void suspend(LocalTransactionStatus defStatus) throws SQLException {
        if (defStatus.isSuspend()) {
            throw new SQLException("the Transaction has Suspend.");
        }
        this.prepareCheckStack(defStatus);
        TransactionObject tranConn = defStatus.getTranConn();
        defStatus.setSuspendConn(tranConn);
        SyncManager.clearSync(this.getDataSource());
        defStatus.setTranConn(this.doGetConnection(defStatus));
    }

    protected final void resume(LocalTransactionStatus defStatus) throws SQLException {
        if (!defStatus.isCompleted()) {
            throw new SQLException("the Transaction has not completed.");
        }
        if (!defStatus.isSuspend()) {
            throw new SQLException("the Transaction has not Suspend.");
        }
        this.prepareCheckStack(defStatus);
        if (defStatus.isSuspend()) {
            TransactionObject tranConn = defStatus.getSuspendConn();
            SyncManager.setSync(tranConn);
            defStatus.setTranConn(tranConn);
            defStatus.setSuspendConn(null);
            tranConn.getHolder().released();
        }
    }

    private void prepareCheckStack(LocalTransactionStatus defStatus) throws SQLException {
        if (!this.isTopTransaction(defStatus)) {
            throw new SQLException("the Transaction Status is not top in stack.");
        }
    }

    private void cleanupAfterCompletion(LocalTransactionStatus defStatus) throws SQLException {
        this.prepareCheckStack(defStatus);
        defStatus.setCompleted();
        TransactionObject tranObj = defStatus.getTranConn();
        Isolation transactionIsolation = tranObj.getRecoverIsolation();
        if (transactionIsolation != null) {
            tranObj.getHolder().getConnection().setTransactionIsolation(transactionIsolation.getValue());
        }
        tranObj.stopTransaction();
        tranObj.getHolder().released();
        if (defStatus.isSuspend()) {
            this.resume(defStatus);
        }
        this.tStatusStack.removeFirst();
        defStatus.setTranConn(null);
        defStatus.setSuspendConn(null);
    }

    protected TransactionObject doGetConnection(LocalTransactionStatus defStatus) throws SQLException {
        ConnectionHolder holder = SyncManager.getHolder(this.dataSource);
        if (!holder.isOpen() || !holder.hasTransaction()) {
            defStatus.markNewConnection();
        }
        holder.requested();
        Connection conn = holder.getConnection();
        if (defStatus.getIsolationLevel() == null) {
            return new TransactionObject(holder, null, this.getDataSource());
        }
        Isolation recoverIsolation = Isolation.valueOf(conn.getTransactionIsolation());
        if (defStatus.getIsolationLevel() != recoverIsolation) {
            conn.setTransactionIsolation(defStatus.getIsolationLevel().getValue());
        }
        return new TransactionObject(holder, recoverIsolation, this.getDataSource());
    }

    public LocalTransactionStatus lastTransaction() {
        return this.tStatusStack.peek();
    }

    @Override
    public void close() throws IOException {
        if (this.tStatusStack.isEmpty()) {
            return;
        }
        try {
            this.commit(this.tStatusStack.getLast());
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

