/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.mapping.reader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import net.hasor.db.mapping.TableReader;
import net.hasor.db.mapping.def.ColumnMapping;
import net.hasor.db.mapping.def.TableMapping;
import net.hasor.db.types.TypeHandler;

public class DefaultTableReader<T>
implements TableReader<T> {
    private final TableMapping<T> tableMapping;

    public DefaultTableReader(TableMapping<T> tableMapping) {
        this.tableMapping = tableMapping;
    }

    @Override
    public T extractRow(List<String> columns, ResultSet rs, int rowNum) throws SQLException {
        T target;
        try {
            target = this.tableMapping.entityType().newInstance();
        }
        catch (Exception e) {
            throw new SQLException("newInstance " + this.tableMapping.entityType().getName() + " failed.", e);
        }
        for (int i = 0; i < columns.size(); ++i) {
            String column = columns.get(i);
            ColumnMapping mapping = this.tableMapping.getPropertyByColumn(column);
            if (mapping == null || mapping.getHandler().isReadOnly()) continue;
            TypeHandler<?> realHandler = mapping.getTypeHandler();
            Object result = realHandler.getResult(rs, i + 1);
            mapping.getHandler().set(target, result);
        }
        return target;
    }
}

