/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.hasor.cobble.ArrayUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.db.dialect.ConditionSqlDialect;
import net.hasor.db.lambda.LambdaTemplate;
import net.hasor.db.lambda.core.BasicLambda;
import net.hasor.db.lambda.core.QueryCompare;
import net.hasor.db.lambda.segment.MergeSqlSegment;
import net.hasor.db.lambda.segment.Segment;
import net.hasor.db.lambda.segment.SqlKeyword;
import net.hasor.db.mapping.def.TableMapping;

public abstract class BasicQueryCompare<R, T, P>
extends BasicLambda<R, T, P>
implements QueryCompare<R, P> {
    protected MergeSqlSegment queryTemplate = new MergeSqlSegment(new Segment[0]);
    protected List<Object> queryParam = new ArrayList<Object>();
    private Segment nextSegmentPrefix = null;
    private boolean lockCondition = false;

    public BasicQueryCompare(Class<?> exampleType, TableMapping<?> tableMapping, LambdaTemplate jdbcTemplate) {
        super(exampleType, tableMapping, jdbcTemplate);
    }

    @Override
    public R nested(Consumer<R> lambda) {
        this.addCondition(SqlKeyword.LEFT);
        this.nextSegmentPrefix = SqlKeyword.EMPTY;
        lambda.accept(this.getSelf());
        this.nextSegmentPrefix = SqlKeyword.EMPTY;
        this.addCondition(SqlKeyword.RIGHT);
        return this.getSelf();
    }

    @Override
    public R or() {
        this.nextSegmentPrefix = SqlKeyword.OR;
        return this.getSelf();
    }

    @Override
    public R and() {
        this.nextSegmentPrefix = SqlKeyword.AND;
        return this.getSelf();
    }

    @Override
    public R apply(String sqlString, Object ... args) {
        if (StringUtils.isBlank((String)sqlString)) {
            return this.getSelf();
        }
        this.queryTemplate.addSegment(() -> {
            if (args != null && args.length > 0) {
                for (Object arg : args) {
                    this.format(arg);
                }
            }
            return sqlString;
        });
        return this.getSelf();
    }

    protected void lockCondition() {
        this.lockCondition = true;
    }

    protected final R addCondition(Segment ... segments) {
        if (this.lockCondition) {
            throw new IllegalStateException("must before (group by/order by) invoke it.");
        }
        if (this.nextSegmentPrefix == SqlKeyword.EMPTY) {
            this.nextSegmentPrefix = null;
        } else if (this.nextSegmentPrefix == null) {
            this.queryTemplate.addSegment(SqlKeyword.AND);
            this.nextSegmentPrefix = null;
        } else {
            this.queryTemplate.addSegment(this.nextSegmentPrefix);
            this.nextSegmentPrefix = null;
        }
        for (Segment segment : segments) {
            this.queryTemplate.addSegment(segment);
        }
        return this.getSelf();
    }

    protected Segment formatLikeValue(ConditionSqlDialect.SqlLike like, Object param) {
        return () -> {
            this.format(param);
            return ((ConditionSqlDialect)this.dialect()).like(like, param);
        };
    }

    protected Segment formatValue(Object ... params) {
        if (ArrayUtils.isEmpty((Object[])params)) {
            return () -> "";
        }
        MergeSqlSegment mergeSqlSegment = new MergeSqlSegment(new Segment[0]);
        Iterator<Object> iterator = Arrays.asList(params).iterator();
        while (iterator.hasNext()) {
            mergeSqlSegment.addSegment(this.formatSegment(iterator.next()));
            if (!iterator.hasNext()) continue;
            mergeSqlSegment.addSegment(() -> ",");
        }
        return mergeSqlSegment;
    }

    protected Segment formatSegment(Object param) {
        return () -> this.format(param);
    }

    protected String format(Object param) {
        this.queryParam.add(param);
        return "?";
    }

    @Override
    public R eq(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.EQ, this.formatValue(value));
    }

    @Override
    public R ne(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.NE, this.formatValue(value));
    }

    @Override
    public R gt(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.GT, this.formatValue(value));
    }

    @Override
    public R ge(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.GE, this.formatValue(value));
    }

    @Override
    public R lt(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.LT, this.formatValue(value));
    }

    @Override
    public R le(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.LE, this.formatValue(value));
    }

    @Override
    public R like(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.DEFAULT, value));
    }

    @Override
    public R notLike(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.DEFAULT, value));
    }

    @Override
    public R likeRight(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.RIGHT, value));
    }

    @Override
    public R notLikeRight(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.RIGHT, value));
    }

    @Override
    public R likeLeft(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.LEFT, value));
    }

    @Override
    public R notLikeLeft(P property, Object value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.LEFT, value));
    }

    @Override
    public R isNull(P property) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.IS_NULL);
    }

    @Override
    public R isNotNull(P property) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.IS_NOT_NULL);
    }

    @Override
    public R in(P property, Collection<?> value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.IN, SqlKeyword.LEFT, this.formatValue(value.toArray()), SqlKeyword.RIGHT);
    }

    @Override
    public R notIn(P property, Collection<?> value) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.NOT, SqlKeyword.IN, SqlKeyword.LEFT, this.formatValue(value.toArray()), SqlKeyword.RIGHT);
    }

    @Override
    public R between(P property, Object value1, Object value2) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.BETWEEN, this.formatValue(value1), SqlKeyword.AND, this.formatValue(value2));
    }

    @Override
    public R notBetween(P property, Object value1, Object value2) {
        return this.addCondition(this.buildColumnByLambda(property), SqlKeyword.NOT, SqlKeyword.BETWEEN, this.formatValue(value1), SqlKeyword.AND, this.formatValue(value2));
    }
}

