/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.function.Property;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.jdbc.DynamicConnection;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.lambda.EntityDeleteOperation;
import net.hasor.db.lambda.EntityQueryOperation;
import net.hasor.db.lambda.EntityUpdateOperation;
import net.hasor.db.lambda.InsertOperation;
import net.hasor.db.lambda.LambdaOperations;
import net.hasor.db.lambda.MapDeleteOperation;
import net.hasor.db.lambda.MapQueryOperation;
import net.hasor.db.lambda.MapUpdateOperation;
import net.hasor.db.lambda.core.BasicLambda;
import net.hasor.db.lambda.support.entity.DeleteLambdaForEntity;
import net.hasor.db.lambda.support.entity.InsertLambdaForEntity;
import net.hasor.db.lambda.support.entity.SelectLambdaForEntity;
import net.hasor.db.lambda.support.entity.UpdateLambdaForEntity;
import net.hasor.db.lambda.support.map.DeleteLambdaForMap;
import net.hasor.db.lambda.support.map.InsertLambdaForMap;
import net.hasor.db.lambda.support.map.SelectLambdaForMap;
import net.hasor.db.lambda.support.map.UpdateLambdaForMap;
import net.hasor.db.mapping.def.ColumnDef;
import net.hasor.db.mapping.def.TableDef;
import net.hasor.db.mapping.def.TableMapping;
import net.hasor.db.mapping.resolve.ClassTableMappingResolve;
import net.hasor.db.mapping.resolve.MappingOptions;
import net.hasor.db.types.TypeHandlerRegistry;
import net.hasor.db.types.UnknownTypeHandler;

public class LambdaTemplate
extends JdbcTemplate
implements LambdaOperations {
    protected final Map<Class<?>, TableMapping<?>> entMapping = new HashMap();
    protected final Map<String, TableMapping<?>> mapMapping = new HashMap();
    protected SqlDialect dialect = null;

    public LambdaTemplate() {
        this.init();
    }

    public LambdaTemplate(DataSource dataSource) {
        super(dataSource);
        this.init();
    }

    public LambdaTemplate(DataSource dataSource, TypeHandlerRegistry typeRegistry) {
        super(dataSource, typeRegistry);
        this.init();
    }

    public LambdaTemplate(Connection conn) {
        super(conn);
        this.init();
    }

    public LambdaTemplate(Connection conn, TypeHandlerRegistry typeRegistry) {
        super(conn, typeRegistry);
    }

    public LambdaTemplate(DynamicConnection dynamicConn) {
        super(dynamicConn);
        this.init();
    }

    public LambdaTemplate(DynamicConnection dynamicConn, TypeHandlerRegistry typeRegistry) {
        super(dynamicConn, typeRegistry);
    }

    protected void init() {
    }

    public void setDialect(SqlDialect dialect) {
        this.dialect = dialect;
    }

    protected <T> TableMapping<T> getTableMapping(Class<T> exampleType, MappingOptions options) {
        if (exampleType == null) {
            throw new NullPointerException("exampleType is null.");
        }
        if (exampleType == Map.class) {
            throw new UnsupportedOperationException("Map cannot be used as lambda exampleType.");
        }
        TableMapping mapping = this.entMapping.get(exampleType);
        if (mapping != null) {
            if (exampleType == mapping.entityType() || exampleType.isAssignableFrom(mapping.entityType())) {
                return mapping;
            }
            throw new ClassCastException("exampleType is incompatible with TableMapping.");
        }
        mapping = this.entMapping.computeIfAbsent(exampleType, key -> {
            MappingOptions opt = new MappingOptions(options);
            opt.setCaseInsensitive(this.isResultsCaseInsensitive());
            return new ClassTableMappingResolve().resolveTableMapping(exampleType, exampleType.getClassLoader(), this.getTypeRegistry(), opt);
        });
        return mapping;
    }

    private List<String> fetchPrimaryKeys(Connection con, String schema, String table) throws SQLException {
        try (ResultSet primaryKeys = con.getMetaData().getPrimaryKeys(null, schema, table);){
            ArrayList<String> keys = new ArrayList<String>();
            while (primaryKeys.next()) {
                keys.add(primaryKeys.getString("COLUMN_NAME"));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
    }

    private List<String> fetchUniqueKeys(Connection con, String schema, String table) throws SQLException {
        try (ResultSet indexInfo = con.getMetaData().getIndexInfo(null, schema, table, false, false);){
            ArrayList<String> keys = new ArrayList<String>();
            while (indexInfo.next()) {
                boolean nonUnique = indexInfo.getBoolean("NON_UNIQUE");
                if (nonUnique) continue;
                keys.add(indexInfo.getString("COLUMN_NAME"));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
    }

    protected List<ColumnDef> fetchColumns(Connection con, String schema, String table, MappingOptions options) throws SQLException {
        if (StringUtils.isBlank((String)schema)) {
            schema = null;
        }
        List<String> primaryKey = this.fetchPrimaryKeys(con, schema, table);
        List<String> uniqueKey = this.fetchUniqueKeys(con, schema, table);
        TypeHandlerRegistry typeRegistry = this.getTypeRegistry();
        try (ResultSet columns = con.getMetaData().getColumns(null, schema, table, null);){
            ArrayList<ColumnDef> result = new ArrayList<ColumnDef>();
            while (columns.next()) {
                String columnName = columns.getString("COLUMN_NAME");
                String propertyName = this.lineToHump(columnName, options.getMapUnderscoreToCamelCase());
                Integer jdbcType = columns.getInt("DATA_TYPE");
                if (columns.wasNull()) {
                    jdbcType = null;
                }
                boolean generated = StringUtils.equalsIgnoreCase((String)"YES", (String)columns.getString("IS_GENERATEDCOLUMN"));
                boolean primary = primaryKey.contains(columnName);
                UnknownTypeHandler typeHandler = jdbcType == null ? typeRegistry.getDefaultTypeHandler() : typeRegistry.getTypeHandler(jdbcType);
                Property mapHandler = BeanUtils.createMapPropertyFunc((String)propertyName);
                result.add(new ColumnDef(columnName, propertyName, jdbcType, Object.class, typeHandler, mapHandler, !generated, !generated, primary));
            }
            ArrayList<ColumnDef> arrayList = result;
            return arrayList;
        }
    }

    private String lineToHump(String str, Boolean mapUnderscoreToCamelCase) {
        if (StringUtils.isBlank((String)str) || mapUnderscoreToCamelCase == null || !mapUnderscoreToCamelCase.booleanValue()) {
            return str;
        }
        return StringUtils.lineToHump((String)str);
    }

    protected TableMapping<?> getTableMapping(String schema, String table, MappingOptions options) throws SQLException {
        if (StringUtils.isBlank((String)table)) {
            throw new NullPointerException("table is blank.");
        }
        String mappingName = String.format("'%s'.'%s'", schema, table);
        TableMapping<?> mapping = this.mapMapping.get(mappingName);
        if (mapping != null) {
            return mapping;
        }
        MappingOptions opt = new MappingOptions(options);
        opt.setCaseInsensitive(this.isResultsCaseInsensitive());
        boolean caseInsensitive = opt.getCaseInsensitive() == null || Boolean.TRUE.equals(opt.getCaseInsensitive());
        TableDef<LinkedHashMap> defMap = new TableDef<LinkedHashMap>(schema, table, LinkedHashMap.class, true, true, caseInsensitive, this.getTypeRegistry());
        List columnDefs = this.execute((Connection con) -> this.fetchColumns(con, schema, table, opt));
        for (ColumnDef cDef : columnDefs) {
            defMap.addMapping(cDef);
        }
        this.mapMapping.put(mappingName, defMap);
        return defMap;
    }

    protected SqlDialect getDefaultDialect() {
        return this.dialect;
    }

    private <E extends BasicLambda<R, T, P>, R, T, P> E configDialect(E execute) {
        SqlDialect dialect = this.getDefaultDialect();
        if (dialect != null) {
            execute.setDialect(dialect);
        }
        return execute;
    }

    @Override
    public <T> InsertOperation<T> lambdaInsert(Class<T> exampleType, MappingOptions options) {
        return this.configDialect(new InsertLambdaForEntity<T>(exampleType, this.getTableMapping(exampleType, options), this));
    }

    @Override
    public InsertOperation<Map<String, Object>> lambdaInsert(String schema, String table, MappingOptions options) throws SQLException {
        return this.configDialect(new InsertLambdaForMap(this.getTableMapping(schema, table, options), this));
    }

    @Override
    public <T> EntityUpdateOperation<T> lambdaUpdate(Class<T> exampleType, MappingOptions options) {
        return this.configDialect(new UpdateLambdaForEntity<T>(exampleType, this.getTableMapping(exampleType, options), this));
    }

    @Override
    public MapUpdateOperation lambdaUpdate(String schema, String table, MappingOptions options) throws SQLException {
        return this.configDialect(new UpdateLambdaForMap(this.getTableMapping(schema, table, options), this));
    }

    @Override
    public <T> EntityDeleteOperation<T> lambdaDelete(Class<T> exampleType, MappingOptions options) {
        return this.configDialect(new DeleteLambdaForEntity<T>(exampleType, this.getTableMapping(exampleType, options), this));
    }

    @Override
    public MapDeleteOperation lambdaDelete(String schema, String table, MappingOptions options) throws SQLException {
        return this.configDialect(new DeleteLambdaForMap(this.getTableMapping(schema, table, options), this));
    }

    @Override
    public <T> EntityQueryOperation<T> lambdaQuery(Class<T> exampleType, MappingOptions options) {
        return this.configDialect(new SelectLambdaForEntity<T>(exampleType, this.getTableMapping(exampleType, options), this));
    }

    @Override
    public MapQueryOperation lambdaQuery(String schema, String table, MappingOptions options) throws SQLException {
        return this.configDialect(new SelectLambdaForMap(this.getTableMapping(schema, table, options), this));
    }
}

