/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.repository.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.ClassUtils;
import net.hasor.cobble.NumberUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.function.Property;
import net.hasor.db.mapping.def.ColumnDef;
import net.hasor.db.mapping.def.ColumnMapping;
import net.hasor.db.mapping.def.TableDef;
import net.hasor.db.mapping.def.TableMapping;
import net.hasor.db.mapping.resolve.ClassTableMappingResolve;
import net.hasor.db.mapping.resolve.MappingOptions;
import net.hasor.db.mapping.resolve.TableMappingResolve;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlTableMappingResolve
implements TableMappingResolve<Node> {
    private final ClassTableMappingResolve classResolveTableMapping = new ClassTableMappingResolve();
    private static final Map<Class<?>, Class<?>> CLASS_MAPPING_MAP = new HashMap();
    private static final Pattern humpPattern;

    @Override
    public TableMapping<?> resolveTableMapping(Node refData, ClassLoader classLoader, TypeHandlerRegistry typeRegistry, MappingOptions options) throws ClassNotFoundException {
        boolean caseInsensitive;
        options = MappingOptions.resolveOptions(refData, options);
        NamedNodeMap nodeAttributes = refData.getAttributes();
        Node typeNode = nodeAttributes.getNamedItem("type");
        Node schemaNode = nodeAttributes.getNamedItem("schema");
        Node tableNode = nodeAttributes.getNamedItem("table");
        String type = typeNode != null ? typeNode.getNodeValue() : null;
        String schemaName = schemaNode != null ? schemaNode.getNodeValue() : null;
        String tableName = tableNode != null ? tableNode.getNodeValue() : null;
        Class<?> entityType = classLoader.loadClass(type);
        if (CLASS_MAPPING_MAP.containsKey(entityType)) {
            entityType = CLASS_MAPPING_MAP.get(entityType);
        }
        if (options.getAutoMapping() != null && options.getAutoMapping().booleanValue()) {
            TableDef<?> tableDef = this.classResolveTableMapping.resolveTableMapping(entityType, classLoader, typeRegistry, options);
            if (StringUtils.isNotBlank((String)schemaName)) {
                tableDef.setSchema(schemaName);
            }
            if (StringUtils.isNotBlank((String)tableName)) {
                tableDef.setTable(tableName);
            }
            return tableDef;
        }
        boolean bl = caseInsensitive = options.getCaseInsensitive() == null || Boolean.TRUE.equals(options.getCaseInsensitive());
        if (StringUtils.isBlank((String)tableName)) {
            tableName = XmlTableMappingResolve.humpToLine(entityType.getSimpleName(), options.getMapUnderscoreToCamelCase());
        }
        TableDef tableDef = new TableDef(schemaName, tableName, entityType, false, false, caseInsensitive, typeRegistry);
        this.loadTableMapping(tableDef, refData, classLoader, typeRegistry);
        return tableDef;
    }

    private void loadTableMapping(TableDef<?> tableDef, Node refData, ClassLoader classLoader, TypeHandlerRegistry typeRegistry) throws ClassNotFoundException {
        Map propertyMap = BeanUtils.getPropertyFunc(tableDef.entityType());
        NodeList childNodes = refData.getChildNodes();
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String elementName = node.getNodeName().toLowerCase().trim();
            if (StringUtils.isBlank((String)elementName)) {
                throw new UnsupportedOperationException("tag name is Empty.");
            }
            ColumnMapping columnMapping = null;
            if ("id".equalsIgnoreCase(elementName)) {
                columnMapping = this.resolveProperty(true, node, propertyMap, classLoader, typeRegistry);
            } else if ("result".equalsIgnoreCase(elementName) || "mapping".equalsIgnoreCase(elementName)) {
                columnMapping = this.resolveProperty(false, node, propertyMap, classLoader, typeRegistry);
            } else {
                throw new UnsupportedOperationException("tag <" + elementName + "> Unsupported.");
            }
            tableDef.addMapping(columnMapping);
        }
    }

    private ColumnMapping resolveProperty(boolean asPrimaryKey, Node xmlNode, Map<String, Property> propertyMap, ClassLoader classLoader, TypeHandlerRegistry typeRegistry) throws ClassNotFoundException {
        String typeHandler;
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        Node columnNode = nodeAttributes.getNamedItem("column");
        Node propertyNode = nodeAttributes.getNamedItem("property");
        Node javaTypeNode = nodeAttributes.getNamedItem("javaType");
        Node jdbcTypeNode = nodeAttributes.getNamedItem("jdbcType");
        Node typeHandlerNode = nodeAttributes.getNamedItem("typeHandler");
        String column = columnNode != null ? columnNode.getNodeValue() : null;
        String property = propertyNode != null ? propertyNode.getNodeValue() : null;
        String javaType = javaTypeNode != null ? javaTypeNode.getNodeValue() : null;
        String jdbcType = jdbcTypeNode != null ? jdbcTypeNode.getNodeValue() : null;
        String string = typeHandler = typeHandlerNode != null ? typeHandlerNode.getNodeValue() : null;
        if (!propertyMap.containsKey(property)) {
            throw new IllegalStateException("property '" + property + "' undefined.");
        }
        Property propertyHandler = propertyMap.get(property);
        Class<?> columnJavaType = XmlTableMappingResolve.resolveJavaType(javaType, propertyHandler, classLoader);
        Integer columnJdbcType = XmlTableMappingResolve.resolveJdbcType(jdbcType, columnJavaType, typeRegistry);
        TypeHandler<?> columnTypeHandler = XmlTableMappingResolve.resolveTypeHandler(columnJavaType, columnJdbcType, classLoader, typeHandler, typeRegistry);
        boolean insert = true;
        boolean update = true;
        return new ColumnDef(column, property, columnJdbcType, columnJavaType, columnTypeHandler, propertyHandler, insert, update, asPrimaryKey);
    }

    private static Class<?> resolveJavaType(String javaType, Property property, ClassLoader classLoader) throws ClassNotFoundException {
        Class columnJavaType = BeanUtils.getPropertyType((Property)property);
        if (StringUtils.isNotBlank((String)javaType)) {
            Class configColumnJavaType = ClassUtils.getClass((ClassLoader)classLoader, (String)javaType);
            if (configColumnJavaType.isAssignableFrom(columnJavaType)) {
                columnJavaType = configColumnJavaType;
            } else {
                throw new ClassCastException(configColumnJavaType.getName() + " is not a subclass of " + columnJavaType.getName());
            }
        }
        return columnJavaType;
    }

    private static Integer resolveJdbcType(String jdbcType, Class<?> javaType, TypeHandlerRegistry typeRegistry) {
        if (NumberUtils.isNumber((String)jdbcType)) {
            return NumberUtils.createInteger((String)jdbcType);
        }
        return TypeHandlerRegistry.toSqlType(javaType);
    }

    private static TypeHandler<?> resolveTypeHandler(Class<?> javaType, Integer jdbcType, ClassLoader classLoader, String typeHandler, TypeHandlerRegistry typeRegistry) throws ClassNotFoundException {
        if (StringUtils.isNotBlank((String)typeHandler)) {
            Class configTypeHandlerType = ClassUtils.getClass((ClassLoader)classLoader, (String)typeHandler);
            if (typeRegistry.hasTypeHandler(configTypeHandlerType)) {
                return typeRegistry.getTypeHandler(configTypeHandlerType);
            }
            if (TypeHandler.class.isAssignableFrom(configTypeHandlerType)) {
                return (TypeHandler)ClassUtils.newInstance((Class)configTypeHandlerType);
            }
            throw new ClassCastException(configTypeHandlerType.getName() + " is not a subclass of " + TypeHandler.class.getName());
        }
        if (typeRegistry.hasTypeHandler(javaType, jdbcType)) {
            return typeRegistry.getTypeHandler(javaType, jdbcType);
        }
        if (typeRegistry.hasTypeHandler(javaType)) {
            return typeRegistry.getTypeHandler(javaType);
        }
        if (typeRegistry.hasTypeHandler(jdbcType)) {
            return typeRegistry.getTypeHandler(jdbcType);
        }
        return typeRegistry.getDefaultTypeHandler();
    }

    private static String humpToLine(String str, Boolean mapUnderscoreToCamelCase) {
        if (StringUtils.isBlank((String)str) || mapUnderscoreToCamelCase == null || !mapUnderscoreToCamelCase.booleanValue()) {
            return str;
        }
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        String strString = sb.toString();
        strString = strString.replaceAll("_{2,}", "_");
        if (strString.charAt(0) == '_') {
            strString = strString.substring(1);
        }
        return strString;
    }

    static {
        CLASS_MAPPING_MAP.put(List.class, ArrayList.class);
        CLASS_MAPPING_MAP.put(Set.class, HashSet.class);
        CLASS_MAPPING_MAP.put(Map.class, HashMap.class);
        humpPattern = Pattern.compile("[A-Z]");
    }
}

