/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.dynamic.rule;

import java.util.Map;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.db.dal.dynamic.rule.AndRule;
import net.hasor.db.dal.dynamic.rule.ArgRule;
import net.hasor.db.dal.dynamic.rule.IncludeRule;
import net.hasor.db.dal.dynamic.rule.MD5Rule;
import net.hasor.db.dal.dynamic.rule.OgnlRule;
import net.hasor.db.dal.dynamic.rule.OrRule;
import net.hasor.db.dal.dynamic.rule.SqlBuildRule;
import net.hasor.db.dal.dynamic.rule.TextRule;
import net.hasor.db.dal.dynamic.rule.UUID32Rule;
import net.hasor.db.dal.dynamic.rule.UUID36Rule;

public class RuleRegistry {
    public static final RuleRegistry DEFAULT = new RuleRegistry();
    private final Map<String, SqlBuildRule> ruleMap = new LinkedCaseInsensitiveMap();

    public SqlBuildRule findByName(String ruleName) {
        SqlBuildRule rule = this.ruleMap.get(ruleName);
        if (rule == null && this != DEFAULT) {
            rule = DEFAULT.findByName(ruleName);
        }
        return rule;
    }

    public void register(String ruleName, SqlBuildRule sqlBuildRule) {
        this.ruleMap.put(ruleName, sqlBuildRule);
    }

    static {
        DEFAULT.register("and", AndRule.INSTANCE);
        DEFAULT.register("or", OrRule.INSTANCE);
        DEFAULT.register("net.hasor.db.jars.ognl", OgnlRule.INSTANCE);
        DEFAULT.register("md5", MD5Rule.INSTANCE);
        DEFAULT.register("uuid32", UUID32Rule.INSTANCE);
        DEFAULT.register("uuid36", UUID36Rule.INSTANCE);
        DEFAULT.register("include", IncludeRule.INSTANCE);
        DEFAULT.register("text", TextRule.INSTANCE);
        DEFAULT.register("arg", ArgRule.INSTANCE);
    }
}

